/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.blocks.GravityBeamBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.util.BeamHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class GravityBeamBlockEntity
extends BlockEntity {
    public GravityBeamBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.GRAVITY_BEAM_BE_TYPE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)GravityBeamBlock.ENABLED)).booleanValue()) {
            return;
        }
        BlockHitResult hit = BeamHelper.rayTrace(level, GravityBeamBlockEntity.start_pos(pos, (Direction)state.m_61143_((Property)GravityBeamBlock.f_52588_)), GravityBeamBlockEntity.xrot(state), GravityBeamBlockEntity.yrot(state), ClipContext.Fluid.NONE, ClipContext.Block.VISUAL, 32.0, null);
        Vec3 particle_start = Vec3.m_82512_((Vec3i)pos);
        particle_start.m_82520_(0.0, 0.1, 0.0);
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.f_123810_, particle_start, Vec3.m_82512_((Vec3i)hit.m_82425_()), 1, 0.05);
        AABB effect_region = new AABB(Vec3.m_82512_((Vec3i)pos).m_82520_(-0.1, -0.1, -0.1), Vec3.m_82512_((Vec3i)hit.m_82425_()).m_82520_(0.1, 0.1, 0.1));
        for (Entity target : level.m_45976_(Entity.class, effect_region)) {
            if (target instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)target;
                victim.m_7292_(new MobEffectInstance((MobEffect)Registration.NULL_GRAVITY.get(), 5));
                victim.m_183634_();
                continue;
            }
            if (!(target instanceof ItemEntity)) continue;
            ItemEntity item = (ItemEntity)target;
            item.m_20242_(true);
        }
    }

    private static Vec3 start_pos(BlockPos center, Direction facing) {
        return Vec3.m_82512_((Vec3i)center).m_231075_(facing, 1.01);
    }

    private static float xrot(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
        if (facing.equals((Object)Direction.UP)) {
            return 270.0f;
        }
        if (facing.equals((Object)Direction.DOWN)) {
            return 90.0f;
        }
        return 0.0f;
    }

    private static float yrot(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
        return facing.m_122435_();
    }
}

