/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.special.SpecialCaseMan;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleShapedBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrucibleBlock
extends CrucibleShapedBlock
implements EntityBlock,
WorldlyContainerHolder {
    public static final BooleanProperty FULL = BooleanProperty.m_61465_((String)"full");
    protected static final VoxelShape INSIDE = Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);

    public CrucibleBlock(BlockBehaviour.Properties p) {
        super(p);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FULL});
        super.m_7926_(builder);
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CrucibleBlockEntity(pos, state);
    }

    public static List<Entity> getEntitesInside(BlockPos pos, Level level) {
        return level.m_45933_(null, INSIDE.m_83215_().m_82338_(pos));
    }

    public void m_6861_(BlockState state, Level level, BlockPos my_pos, Block block, BlockPos neighbor_pos, boolean unknown_flag) {
        BlockEntity blockEntity;
        int signal = level.m_277173_(my_pos);
        if (signal > WorldSpecificValue.get("redstone_void_threshold", 11, 14) && (blockEntity = level.m_7702_(my_pos)) instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
            switch (WorldSpecificValue.get("redstone_behavior", 0, 2)) {
                case 0: {
                    CrucibleBlockEntity.empty(level, my_pos, state, crucible);
                    crucible.setDirty();
                    break;
                }
                case 1: {
                    if (crucible.getTotalPowerLevel() > 1500) {
                        CrucibleBlockEntity.empty(level, my_pos, state, crucible);
                    } else {
                        crucible.expendAnyPowerExcept((Power)Powers.CURSE_POWER.get(), 1500);
                    }
                    crucible.setDirty();
                    break;
                }
                case 2: {
                    state.m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false));
                }
            }
            CrucibleBlockEntity.empty(level, my_pos, state, crucible);
            level.m_5594_(null, my_pos, SoundEvents.f_11738_, SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.1f);
        }
    }

    private boolean checkFluidInStack(IFluidHandlerItem container, Fluid criterion) {
        if (container == null) {
            return false;
        }
        for (int i = 0; i < container.getTanks(); ++i) {
            if (!container.getFluidInTank(i).containsFluid(new FluidStack(criterion, 1000))) continue;
            return true;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            if (player.m_21120_(hand).m_150930_((Item)Registration.ACID_BUCKET.get())) {
                BlockEntity crucible = level.m_7702_(pos);
                if (!(crucible instanceof CrucibleBlockEntity)) {
                    return InteractionResult.PASS;
                }
                CrucibleBlockEntity c = (CrucibleBlockEntity)crucible;
                c.setStartingColor(((Power)Powers.ACID_POWER.get()).getColor());
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_150930_((Item)Registration.LITMUS_PAPER.get())) {
            return InteractionResult.PASS;
        }
        if (!((Boolean)state.m_61143_((Property)FULL)).booleanValue()) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)player.m_21120_(hand).m_41777_()).orElse(null);
            if (this.checkFluidInStack(fluidHandler, (Fluid)Fluids.f_76193_)) {
                CrucibleBlock.becomeFull(state, level, pos, (ServerPlayer)player);
                if (((ServerPlayer)player).f_8941_.m_9294_()) {
                    fluidHandler.drain(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                    player.m_21008_(hand, fluidHandler.getContainer());
                }
                return InteractionResult.CONSUME;
            }
            if (this.checkFluidInStack(fluidHandler, (Fluid)Fluids.f_76195_)) {
                CrucibleBlock.lavaCrucibleFill(level, pos, (ServerPlayer)player);
                if (((ServerPlayer)player).f_8941_.m_9294_()) {
                    fluidHandler.drain(new FluidStack((Fluid)Fluids.f_76195_, 1000), IFluidHandler.FluidAction.EXECUTE);
                    player.m_21008_(hand, fluidHandler.getContainer());
                }
                return InteractionResult.CONSUME;
            }
            if (player.m_21120_(hand).m_150930_((Item)Registration.ACID_BUCKET.get())) {
                BlockEntity crucible = level.m_7702_(pos);
                if (!(crucible instanceof CrucibleBlockEntity)) {
                    return InteractionResult.PASS;
                }
                CrucibleBlockEntity c = (CrucibleBlockEntity)crucible;
                CrucibleBlock.becomeFull(state, level, pos, (ServerPlayer)player);
                c.addPower((Power)Powers.ACID_POWER.get(), WorldSpecificValues.BOTTLE_RETURN.get() * 3);
                c.setDirty();
                if (((ServerPlayer)player).f_8941_.m_9294_()) {
                    player.m_21008_(hand, Items.f_42446_.m_7968_());
                }
                return InteractionResult.CONSUME;
            }
        }
        if (((Boolean)state.m_61143_((Property)FULL)).booleanValue()) {
            BlockEntity crucible = level.m_7702_(pos);
            if (!(crucible instanceof CrucibleBlockEntity)) {
                return InteractionResult.PASS;
            }
            CrucibleBlockEntity c = (CrucibleBlockEntity)crucible;
            if (player.m_6144_()) {
                level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 0.6f, 0.8f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false)), 2);
            }
            if (player.m_21120_(hand).m_150930_(Items.f_42590_)) {
                CrucibleBlock.extractGlassBottle(state, level, pos, player, hand, c);
            }
            if (player.m_21120_(hand).m_150930_((Item)Registration.QUARTZ_BOTTLE.get())) {
                CrucibleBlock.extractQuartzBottle(level, pos, player, hand, c);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void becomeFull(BlockState state, Level level, BlockPos pos, ServerPlayer player) {
        if (level.m_6042_().f_63857_()) {
            CrucibleBlock.netherCrucibleFill(level, pos, player);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FULL, (Comparable)Boolean.valueOf(true)), 2);
            level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 0.4f, 1.0f);
        }
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)level.m_8055_(pos)));
    }

    private static void extractQuartzBottle(Level level, BlockPos pos, Player player, InteractionHand hand, CrucibleBlockEntity c) {
        for (Power p : c.getPowerMap().keySet()) {
            if (!p.hasBottle() || c.getPowerLevel(p) <= 600) continue;
            c.expendPower(p, 600);
            player.m_36356_(SpecialCaseMan.checkBottleSpecialCases(c, p.getBottle()));
            player.m_21120_(hand).m_41774_(1);
            level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 0.8f, 1.0f);
            level.m_220407_(GameEvent.f_223697_, pos, GameEvent.Context.m_223722_((BlockState)level.m_8055_(pos)));
        }
        c.setDirty();
    }

    private static void extractGlassBottle(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, CrucibleBlockEntity c) {
        int amount = player.m_21120_(hand).m_41613_();
        amount = Math.min(amount, 3);
        for (int i = 0; i < amount; ++i) {
            if (c.getTotalPowerLevel() == 0) {
                player.m_36356_(Items.f_42589_.m_7968_());
                continue;
            }
            ItemStack potion = Items.f_42589_.m_7968_();
            if (c.getPowerLevel((Power)Powers.BODY_POWER.get()) > 10) {
                PotionUtils.m_43549_((ItemStack)potion, (Potion)Potions.f_43601_);
            } else if (c.getPowerLevel((Power)Powers.ACID_POWER.get()) > 50) {
                PotionUtils.m_43549_((ItemStack)potion, (Potion)Potions.f_43602_);
            } else {
                PotionUtils.m_43549_((ItemStack)potion, (Potion)Potions.f_43600_);
            }
            player.m_36356_(potion);
        }
        player.m_21120_(hand).m_41774_(amount);
        level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)level.m_8055_(pos)));
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false)), 2);
    }

    private static void lavaCrucibleFill(Level level, BlockPos pos, ServerPlayer player) {
        level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1.0f, Level.ExplosionInteraction.NONE);
        level.m_5594_(null, pos, SoundEvents.f_11909_, SoundSource.BLOCKS, 0.5f, 1.0f);
        for (int i = 0; i < 5; ++i) {
            ParticleScribe.drawParticleCrucibleTop(level, (ParticleOptions)ParticleTypes.f_123755_, pos);
        }
        ParticleScribe.drawParticleRing(level, (ParticleOptions)Registration.RUNE_PARTICLE, pos, 0.7, 0.9, 7);
        level.m_7731_(pos, Blocks.f_152477_.m_49966_(), 2);
        CriteriaTriggers.TRY_LAVA_CRUCIBLE_TRIGGER.trigger(player);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)level.m_8055_(pos)));
    }

    private static void netherCrucibleFill(Level level, BlockPos pos, ServerPlayer player) {
        level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
        for (int i = 0; i < 5; ++i) {
            ParticleScribe.drawParticleCrucibleTop(level, (ParticleOptions)ParticleTypes.f_123755_, pos);
        }
        CriteriaTriggers.TRY_NETHER_CRUCIBLE_TRIGGER.trigger(player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean p_60519_) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
            if (!level.f_46443_) {
                CrucibleBlockEntity.empty(level, pos, state, crucible);
                if (crucible.integrity < 10) {
                    CrucibleBlockEntity.integrityFail(level, pos, state);
                }
            }
        }
        super.m_6810_(state, level, pos, new_state, p_60519_);
    }

    public void onRemoveWithoutEmpty(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean p_60519_) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
            if (crucible.linked_crystal != null) {
                crucible.unlinkCrystal(level, pos, state);
            }
        }
        super.m_6810_(state, level, pos, new_state, p_60519_);
    }

    public boolean m_7278_(BlockState state) {
        return (Boolean)state.m_61143_((Property)FULL);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CrucibleBlockEntity)) {
            return 0;
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
        if (crucible.integrity < 85) {
            return 0;
        }
        if (crucible.used_crystal_this_cycle) {
            return 15;
        }
        int signal = (Boolean)state.m_61143_((Property)FULL) != false ? 1 : 0;
        signal += crucible.getTotalPowerLevel() / WorldSpecificValue.get("signal_pl_divisor", 133, 400);
        if (crucible.electricCharge > 5) {
            signal += WorldSpecificValue.get("electric_signal_value", 1, 7);
        }
        if (crucible.enderRiftStrength > 1) {
            signal += level.f_46441_.m_216339_(1, 7);
        }
        return Math.min(signal, 15);
    }

    @Nullable
    public <CrucibleBlockEntity extends BlockEntity> BlockEntityTicker<CrucibleBlockEntity> m_142354_(Level level, BlockState state, BlockEntityType<CrucibleBlockEntity> type) {
        if (type == Registration.CRUCIBLE_BE.get()) {
            return (l, p, s, c) -> CrucibleBlockEntity.tick(l, p, s, (CrucibleBlockEntity)c);
        }
        return null;
    }

    public WorldlyContainer m_5840_(BlockState state, LevelAccessor accessor, BlockPos pos) {
        return new EntityInsideContainer(state, accessor, pos);
    }

    static class EntityInsideContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;

        public EntityInsideContainer(BlockState state, LevelAccessor level, BlockPos pos) {
            super(0);
            this.state = state;
            this.level = level;
            this.pos = pos;
        }

        private List<ItemStack> getEntitySlots() {
            ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
            for (Entity entity : CrucibleBlock.getEntitesInside(this.pos, (Level)this.level)) {
                if (!(entity instanceof ItemEntity)) continue;
                slots.add(((ItemEntity)entity).m_32055_());
            }
            return slots;
        }

        public int m_6643_() {
            return this.getEntitySlots().size() + 1;
        }

        public int @NotNull [] m_7071_(Direction face) {
            int size = this.m_6643_();
            int[] slots_array = new int[size];
            for (int i = 0; i < size; ++i) {
                slots_array[i] = i;
            }
            return slots_array;
        }

        public boolean m_7155_(int unknown, ItemStack stack, @Nullable Direction face) {
            return (Boolean)this.state.m_61143_((Property)FULL);
        }

        public boolean m_7157_(int unknown, ItemStack stack, Direction face) {
            return false;
        }

        public ItemStack m_8020_(int slot) {
            if (slot >= this.m_6643_() - 1) {
                return ItemStack.f_41583_;
            }
            return this.getEntitySlots().get(slot);
        }

        public void m_6836_(int slot, ItemStack stack) {
            if (slot == this.getEntitySlots().size()) {
                ItemEntity ingredient_drop = new ItemEntity((Level)this.level, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5265, (double)this.pos.m_123343_() + 0.5, stack);
                ingredient_drop.m_32010_(50);
                ingredient_drop.m_20334_(0.0, 0.0, 0.0);
                this.level.m_7967_((Entity)ingredient_drop);
            } else {
                this.getEntitySlots().set(slot, stack);
            }
        }
    }
}

