/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NoduleBlock
extends DirectionalBlock {
    private final boolean small;
    private static final VoxelShape SMALL_FLOOR_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)10.0);
    private static final VoxelShape SMALL_CEILING_SHAPE = Block.m_49796_((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SMALL_WEST_SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)3.0, (double)10.0, (double)10.0);
    private static final VoxelShape SMALL_EAST_SHAPE = Block.m_49796_((double)13.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SMALL_NORTH_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)3.0);
    private static final VoxelShape SMALL_SOUTH_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)13.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape FLOOR_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape CEILING_SHAPE = Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)6.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0);

    public NoduleBlock(BlockBehaviour.Properties properties, boolean small_hitbox) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.DOWN));
        this.small = small_hitbox;
    }

    private NoduleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.DOWN));
        this.small = false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_});
        super.m_7926_(builder);
    }

    private boolean isSmall() {
        return this.small;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)f_52588_)) {
            case UP: {
                return this.isSmall() ? SMALL_CEILING_SHAPE : CEILING_SHAPE;
            }
            case WEST: {
                return this.isSmall() ? SMALL_WEST_SHAPE : WEST_SHAPE;
            }
            case EAST: {
                return this.isSmall() ? SMALL_EAST_SHAPE : EAST_SHAPE;
            }
            case NORTH: {
                return this.isSmall() ? SMALL_NORTH_SHAPE : NORTH_SHAPE;
            }
            case SOUTH: {
                return this.isSmall() ? SMALL_SOUTH_SHAPE : SOUTH_SHAPE;
            }
        }
        return this.isSmall() ? SMALL_FLOOR_SHAPE : FLOOR_SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_43719_().m_122424_());
    }
}

