/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.gui;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.client.gui.BetterFittingMultiLineTextWidget;
import dev.hyperlynx.reactive.client.gui.ScreenOpener;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.menu.DeskMenu;
import dev.hyperlynx.reactive.util.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DeskScreen
extends AbstractContainerScreen<DeskMenu> {
    private static final ResourceLocation DESK_BACKGROUND_LOCATION = ReactiveMod.location("textures/gui/discovery_desk.png");
    private static final ResourceLocation VIEW_DISCOVERIES_BUTTON = ReactiveMod.location("textures/gui/discoveries_tab.png");
    final Button rename_button = new Button.Builder((Component)Component.m_237119_(), button -> {
        ItemStack stack;
        ResourceLocation location;
        if (((DeskMenu)this.m_6262_()).m_38853_(0).m_6657_() && (location = MaterialItem.getMaterialId(stack = ((DeskMenu)this.m_6262_()).m_38853_(0).m_7993_())) != null) {
            ScreenOpener.materialRename(location);
        }
    }).m_253136_();
    final Button discoveries_button = new ImageButton(0, 0, 20, 20, 0, 0, 20, VIEW_DISCOVERIES_BUTTON, 20, 80, button -> ScreenOpener.materialList(), (Component)Component.m_237115_((String)"button.reactive.discoveries"));
    BetterFittingMultiLineTextWidget readout;
    int slot_x;
    int slot_y;
    ResourceLocation last_material = ReactiveMod.location("null");
    private static final List<Rect> DECORATIONS = List.of(new Rect(21, 20, 46, 20), new Rect(21, 45, 46, 45), new Rect(21, 20, 21, 45), new Rect(46, 20, 46, 45));

    public DeskScreen(DeskMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.slot_x = ((DeskMenu)this.m_6262_()).m_38853_((int)0).f_40220_ + this.getGuiLeft();
        this.slot_y = ((DeskMenu)this.m_6262_()).m_38853_((int)0).f_40221_ + this.getGuiTop();
        this.rename_button.f_93624_ = false;
        this.rename_button.f_93623_ = false;
        this.rename_button.m_264152_(this.slot_x - 16, this.slot_y + 24);
        this.rename_button.m_93674_(51);
        this.m_142416_((GuiEventListener)this.rename_button);
        this.discoveries_button.m_264152_(this.getGuiLeft() + 150, this.getGuiTop() - 17);
        this.m_142416_((GuiEventListener)this.discoveries_button);
        this.readout = null;
    }

    private Material getMaterial() {
        return MaterialMan.fetch((Level)Minecraft.m_91087_().f_91073_, this.getMaterialId());
    }

    private ResourceLocation getMaterialId() {
        ItemStack stack = ((DeskMenu)this.m_6262_()).m_38853_(0).m_7993_();
        if (!MaterialItem.hasMaterialId(stack)) {
            return null;
        }
        return MaterialItem.getMaterialId(stack);
    }

    protected void m_181908_() {
        this.rename_button.f_93623_ = false;
        this.rename_button.f_93624_ = false;
        this.rename_button.m_257544_(null);
        if (((DeskMenu)this.m_6262_()).m_38853_(0).m_6657_()) {
            Material material = this.getMaterial();
            if (material != null) {
                this.updateButton(material);
                ResourceLocation material_id = this.getMaterialId();
                if (material_id != null) {
                    this.updateReadout(material, material_id);
                }
            }
        } else {
            if (this.readout != null) {
                this.m_169411_((GuiEventListener)this.readout);
                this.last_material = ReactiveMod.location("null");
            }
            this.readout = null;
        }
    }

    private void updateButton(Material material) {
        this.rename_button.f_93624_ = true;
        if (material.wasDiscovered()) {
            this.rename_button.m_93666_((Component)Component.m_237115_((String)"ui.reactive.rename_button"));
            if (material.playerDiscoveredThis((Player)Minecraft.m_91087_().f_91074_)) {
                this.rename_button.f_93623_ = true;
            } else {
                this.rename_button.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"text.reactive.cannot_rename_others_discovery")));
            }
        } else {
            this.rename_button.m_93666_((Component)Component.m_237115_((String)"ui.reactive.discover_button"));
            this.rename_button.f_93623_ = true;
        }
    }

    private void updateReadout(Material material, ResourceLocation material_id) {
        if (material_id.equals((Object)this.last_material) && this.readout != null) {
            return;
        }
        this.last_material = material_id;
        if (this.readout != null) {
            this.m_169411_((GuiEventListener)this.readout);
        }
        this.readout = new BetterFittingMultiLineTextWidget(this.slot_x + 39, this.slot_y - 6, 104, 60, (Component)material.formulaComponent(), Minecraft.m_91087_().f_91062_);
        this.m_142416_((GuiEventListener)this.readout);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(DESK_BACKGROUND_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        this.renderDecorations(guiGraphics);
    }

    private void renderDecorations(GuiGraphics graphics) {
        if (this.getMaterialId() == null) {
            return;
        }
        Color color = (Color)this.getMaterial().get((MaterialProperty)MaterialProperties.COLOR.get());
        if (color == null) {
            return;
        }
        for (Rect rect : DECORATIONS) {
            graphics.m_280509_(rect.x1 + this.getGuiLeft(), rect.y1 + this.getGuiTop(), rect.x2 + this.getGuiLeft() + 1, rect.y2 + this.getGuiTop() + 1, 0xFF000000 | color.hex);
        }
    }

    private record Rect(int x1, int y1, int x2, int y2) {
    }
}

