/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.util.Color;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.Position;
import net.minecraft.core.particles.DustParticleOptionsBase;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final Vec3 target;
    private float speed = 0.05f;
    private final boolean reversed;
    private final boolean orbit;
    public static final ParticleOptions.Deserializer<Options> DESERIALIZER = new ParticleOptions.Deserializer<Options>(){

        public Options fromCommand(ParticleType<Options> type, StringReader reader) throws CommandSyntaxException {
            try {
                return new Options(reader.readFloat(), new Color(reader.readInt()), new Vec3(reader.readDouble(), reader.readDouble(), reader.readDouble()), reader.readBoolean(), reader.readBoolean());
            }
            catch (Exception e) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().create((Object)e);
            }
        }

        public Options fromNetwork(ParticleType<Options> type, FriendlyByteBuf buf) {
            return new Options(buf.readFloat(), new Color(buf.readInt()), new Vec3(buf.m_269394_()), buf.readBoolean(), buf.readBoolean());
        }
    };

    protected EnergyParticle(ClientLevel level, double x, double y, double z, Options options, SpriteSet sprites) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.target = options.getTarget();
        this.m_6569_(options.m_175813_());
        this.f_107227_ = options.m_252837_().x / 255.0f;
        this.f_107228_ = options.m_252837_().y / 255.0f;
        this.f_107229_ = options.m_252837_().z / 255.0f;
        this.f_107219_ = false;
        this.reversed = options.reverse_motion;
        this.orbit = options.orbit;
        this.m_107257_(this.reversed || this.orbit ? 20 : 200);
        this.m_108339_(sprites);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float p_172146_) {
        return LightTexture.m_109885_((int)15, (int)15);
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        if (!this.reversed && this.getPos().m_82509_((Position)this.target, (double)(this.speed + 0.01f))) {
            this.m_107274_();
        }
    }

    public void m_6257_(double x, double y, double z) {
        Vec3 move_step;
        Vec3 pos = this.getPos();
        if (this.orbit) {
            Vec3 normalized_toward_center = this.target.m_82546_(pos).m_82541_();
            Vec3 normalized_tangent = new Vec3(-normalized_toward_center.f_82481_, 0.0, normalized_toward_center.f_82479_);
            move_step = normalized_tangent.m_82490_((double)this.speed);
        } else {
            move_step = this.target.m_82546_(pos).m_82541_().m_82490_((double)this.speed);
        }
        if (this.reversed) {
            move_step = move_step.m_82548_();
        }
        super.m_6257_(move_step.f_82479_, move_step.f_82480_, move_step.f_82481_);
    }

    public static class Options
    extends DustParticleOptionsBase {
        final float speed;
        final Color color;
        final Vec3 target;
        final boolean reverse_motion;
        final boolean orbit;
        protected static final MapCodec<Options> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("speed").forGetter(Options::getSpeed), (App)Color.CODEC.fieldOf("color").forGetter(Options::getHyperColor), (App)Vec3.f_231074_.fieldOf("target").forGetter(Options::getTarget), (App)Codec.BOOL.fieldOf("reversed").forGetter(Options::isReversed), (App)Codec.BOOL.fieldOf("orbit").forGetter(Options::isOrbiting)).apply((Applicative)instance, Options::new));

        public Options(Color color, Vec3 target) {
            this(0.05f, color, target);
        }

        public Options(float speed, Color color, Vec3 target) {
            this(speed, color, target, false);
        }

        public Options(float speed, Color color, Vec3 target, boolean reverse) {
            this(speed, color, target, reverse, false);
        }

        public Options(float speed, Color color, Vec3 target, boolean reverse, boolean orbit) {
            super(color.toVector3f(), 0.1f);
            this.speed = speed;
            this.color = color;
            this.target = target;
            this.reverse_motion = reverse;
            this.orbit = orbit;
        }

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)Registration.ENERGY_PARTICLE_TYPE.get();
        }

        private Color getHyperColor() {
            return this.color;
        }

        public float getSpeed() {
            return this.speed;
        }

        public Vec3 getTarget() {
            return this.target;
        }

        public boolean isReversed() {
            return this.reverse_motion;
        }

        private boolean isOrbiting() {
            return this.orbit;
        }
    }

    public static class Provider
    implements ParticleProvider<Options> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(@NotNull Options options, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EnergyParticle particle = new EnergyParticle(level, x, y, z, options, this.sprites);
            particle.speed = options.getSpeed();
            return particle;
        }
    }

    public static class Type
    extends ParticleType<Options> {
        public Type() {
            super(false, DESERIALIZER);
        }

        @NotNull
        public Codec<Options> m_7652_() {
            return Options.CODEC.codec();
        }
    }
}

