/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.particles;

import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.entities.ReactorEntity;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ParticleScribe {
    public static void drawParticle(Level level, ParticleOptions opt, double x, double y, double z) {
        if (level.m_5776_()) {
            level.m_7106_(opt, x, y, z, 0.0, 0.0, 0.0);
        } else {
            ((ServerLevel)level).m_8767_(opt, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void drawParticle(Level level, ParticleOptions opt, double x, double y, double z, float odds, double xspeed, double yspeed, double zspeed) {
        if (level.f_46441_.m_188501_() < odds) {
            if (level.m_5776_()) {
                level.m_7106_(opt, x, y, z, xspeed, yspeed, zspeed);
            } else {
                ((ServerLevel)level).m_8767_(opt, x, y, z, 1, xspeed, yspeed, zspeed, 0.0);
            }
        }
    }

    public static void drawParticleBox(Level level, ParticleOptions opt, AABB aabb, int frequency) {
        for (int i = 0; i < frequency; ++i) {
            double x = level.f_46441_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_) + aabb.f_82288_;
            double y = level.f_46441_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_) + aabb.f_82289_;
            double z = level.f_46441_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_) + aabb.f_82290_;
            ParticleScribe.drawParticle(level, opt, x, y, z);
        }
    }

    public static void drawParticleLine(Level level, ParticleOptions opt, BlockPos a, BlockPos b, int frequency, double noise) {
        ParticleScribe.drawParticleLine(level, opt, (double)a.m_123341_() + 0.5, (double)a.m_123342_() + 0.5, (double)a.m_123343_() + 0.5, (double)b.m_123341_() + 0.5, (double)b.m_123342_() + 0.5, (double)b.m_123343_() + 0.5, frequency, noise);
    }

    public static void drawParticleLine(Level level, ParticleOptions opt, Vec3 a, Vec3 b, int frequency, double noise) {
        ParticleScribe.drawParticleLine(level, opt, a.f_82479_, a.f_82480_, a.f_82481_, b.f_82479_, b.f_82480_, b.f_82481_, frequency, noise);
    }

    public static void drawParticleLine(Level level, ParticleOptions opt, double x1, double y1, double z1, double x2, double y2, double z2, int frequency, double noise) {
        for (int i = 0; i < frequency; ++i) {
            double u = level.f_46441_.m_188500_();
            double x = (1.0 - u) * x1 + u * x2;
            double y = (1.0 - u) * y1 + u * y2;
            double z = (1.0 - u) * z1 + u * z2;
            ParticleScribe.drawParticle(level, opt, x += ((double)level.f_46441_.m_188501_() - 0.5) * noise, y += ((double)level.f_46441_.m_188501_() - 0.5) * noise, z += ((double)level.f_46441_.m_188501_() - 0.5) * noise);
        }
    }

    public static void drawParticleZigZag(Level level, ParticleOptions opt, BlockPos a, BlockPos b, int frequency, int segments, double noise) {
        ParticleScribe.drawParticleZigZag(level, opt, (double)a.m_123341_() + 0.5, (double)a.m_123342_() + 0.5, (double)a.m_123343_() + 0.5, (double)b.m_123341_() + 0.5, (double)b.m_123342_() + 0.5, (double)b.m_123343_() + 0.5, frequency, segments, noise);
    }

    public static void drawParticleZigZag(Level level, ParticleOptions opt, double x1, double y1, double z1, double x2, double y2, double z2, int frequency, int segments, double noise) {
        double prev_x = x1;
        double prev_y = y1;
        double prev_z = z1;
        for (int i = 0; i < segments; ++i) {
            double next_z;
            double next_y;
            double next_x;
            if (i == segments - 1) {
                next_x = x2;
                next_y = y2;
                next_z = z2;
            } else {
                double min_progress = 1.0 / (double)(segments + 3);
                double max_progress = segments == 3 ? 1.0 : 1.0 / (double)(segments - 3);
                double actual_progress = ThreadLocalRandom.current().nextDouble(min_progress, max_progress);
                double x_dist = Math.abs(x2 - prev_x) * actual_progress;
                double y_dist = Math.abs(y2 - prev_y) * actual_progress;
                double z_dist = Math.abs(z2 - prev_z) * actual_progress;
                if (x2 > 0.0) {
                    next_x = x2 > prev_x ? prev_x + x_dist : prev_x - x_dist;
                } else {
                    double d = next_x = x2 < prev_x ? prev_x - x_dist : prev_x + x_dist;
                }
                if (y2 > 0.0) {
                    next_y = y2 > prev_y ? prev_y + y_dist : prev_y - y_dist;
                } else {
                    double d = next_y = y2 < prev_y ? prev_y - y_dist : prev_y + y_dist;
                }
                next_z = z2 > 0.0 ? (z2 > prev_z ? prev_z + z_dist : prev_z - z_dist) : (z2 < prev_z ? prev_z - z_dist : prev_z + z_dist);
                next_x += ((double)level.f_46441_.m_188501_() - 0.5) * noise;
                next_y += ((double)level.f_46441_.m_188501_() - 0.5) * noise;
                next_z += ((double)level.f_46441_.m_188501_() - 0.5) * noise;
            }
            ParticleScribe.drawParticleLine(level, opt, prev_x, prev_y, prev_z, next_x, next_y, next_z, frequency, 0.0);
            prev_x = next_x;
            prev_y = next_y;
            prev_z = next_z;
        }
    }

    public static void drawParticleRing(Level level, ParticleOptions opt, BlockPos pos, double height, double radius, int frequency) {
        ParticleScribe.drawExactParticleRing(level, opt, Vec3.m_82539_((Vec3i)pos), height, radius, frequency);
    }

    public static void drawExactParticleRing(Level level, ParticleOptions opt, Vec3 pos, double height, double radius, int frequency) {
        for (int i = 0; i < frequency; ++i) {
            int deflection_angle = level.f_46441_.m_216339_(1, 360);
            ParticleScribe.drawDeflectedParticle(level, opt, pos, height, radius, deflection_angle);
        }
    }

    public static void drawDeflectedParticle(Level level, ParticleOptions opt, Vec3 pos, double height, double radius, int deflection_angle) {
        double x = Math.cos(Math.toRadians(deflection_angle)) * radius + pos.f_82479_;
        double z = Math.sin(Math.toRadians(deflection_angle)) * radius + pos.f_82481_;
        ParticleScribe.drawParticle(level, opt, x, pos.f_82480_ + height, z);
    }

    public static void drawParticleSphere(Level level, ParticleOptions opt, BlockPos pos, double height, double radius, int frequency) {
        double center_x = (double)pos.m_123341_() + 0.5;
        double center_z = (double)pos.m_123343_() + 0.5;
        ParticleScribe.drawExactParticleSphere(level, opt, new Vec3(center_x, (double)pos.m_123342_(), center_z), height, radius, frequency);
    }

    public static void drawExactParticleSphere(Level level, ParticleOptions opt, Vec3 pos, double height, double radius, int frequency) {
        for (int i = 0; i < frequency; ++i) {
            double x = level.f_46441_.m_188583_();
            double y = level.f_46441_.m_188583_();
            double z = level.f_46441_.m_188583_();
            double normalizer = 1.0 / Math.sqrt(x * x + y * y + z * z);
            x = x * normalizer * radius;
            y = y * normalizer * radius;
            z = z * normalizer * radius;
            ParticleScribe.drawParticle(level, opt, pos.f_82479_ + x, pos.f_82480_ + height + y, pos.f_82481_ + z);
        }
    }

    public static void drawParticleCrucibleTop(Level level, ParticleOptions opt, BlockPos pos) {
        ParticleScribe.drawParticleCrucibleTop(level, opt, pos, 1.0f, 0.0, 0.0, 0.0);
    }

    public static void drawParticleCrucibleTop(Level level, ParticleOptions opt, BlockPos pos, float odds) {
        ParticleScribe.drawParticleCrucibleTop(level, opt, pos, odds, 0.0, 0.0, 0.0);
    }

    public static void drawParticleCrucibleTop(Level level, ParticleOptions opt, BlockPos pos, float odds, double xspeed, double yspeed, double zspeed) {
        if (level.m_5776_()) {
            if (level.f_46441_.m_188501_() < odds) {
                double x = (double)pos.m_123341_() + (double)level.m_213780_().m_188501_() * 0.625 + 0.1875;
                double z = (double)pos.m_123343_() + (double)level.m_213780_().m_188501_() * 0.625 + 0.1875;
                level.m_7106_(opt, x, (double)pos.m_123342_() + 0.6, z, xspeed, yspeed, zspeed);
            }
        } else if (level.f_46441_.m_188501_() < odds) {
            double x = (double)pos.m_123341_() + (double)level.m_213780_().m_188501_() * 0.625 + 0.1875;
            double z = (double)pos.m_123343_() + (double)level.m_213780_().m_188501_() * 0.625 + 0.1875;
            ((ServerLevel)level).m_8767_(opt, x, (double)pos.m_123342_() + 0.6, z, 1, xspeed, yspeed, zspeed, 0.0);
        }
    }

    public static void drawParticleReactionSurface(Level level, ParticleOptions opt, Reactor reactor) {
        ParticleScribe.drawParticleReactionSurface(level, opt, reactor, 1.0f, 0.0, 0.0, 0.0);
    }

    public static void drawParticleReactionSurface(Level level, ParticleOptions opt, Reactor reactor, float odds) {
        ParticleScribe.drawParticleReactionSurface(level, opt, reactor, odds, 0.0, 0.0, 0.0);
    }

    public static void drawParticleReactionSurface(Level level, ParticleOptions opt, Reactor reactor, float odds, double xspeed, double yspeed, double zspeed) {
        if (reactor instanceof CrucibleBlockEntity) {
            ParticleScribe.drawParticleCrucibleTop(level, opt, reactor.blockPos(), odds, xspeed, yspeed, zspeed);
        } else if (reactor instanceof ReactorEntity) {
            ParticleScribe.drawParticle(level, opt, reactor.getPos().f_82479_, reactor.getPos().f_82480_, reactor.getPos().f_82481_, odds, xspeed, yspeed, zspeed);
        } else {
            throw new UnsupportedOperationException("No reaction surface defined for reactor type '" + reactor.getClass() + "' !");
        }
    }
}

