/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.client.renderers.rxn.ReactorRenderer;
import dev.hyperlynx.reactive.util.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class CrucibleRenderer
implements BlockEntityRenderer<CrucibleBlockEntity>,
ReactorRenderer {
    private final BlockRenderDispatcher blockRenderDispatcher;

    public CrucibleRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderDispatcher = context.m_173584_();
    }

    private TextureAtlasSprite getSprite(CrucibleBlockEntity crucible) {
        if (((Boolean)ConfigMan.CLIENT.doNotChangeWaterTexture.get()).booleanValue()) {
            return this.blockRenderDispatcher.m_110910_(Blocks.f_49990_.m_49966_()).getParticleIcon(ModelData.EMPTY);
        }
        if (crucible.integrity < 20 && crucible.integrity > 8) {
            return this.blockRenderDispatcher.m_110910_(((Block)Registration.DUMMY_NOISE_WATER.get()).m_49966_()).getParticleIcon(ModelData.EMPTY);
        }
        int threshold = 800;
        if (crucible.getTotalPowerLevel() > threshold) {
            Power max_power = null;
            int max_level = 0;
            for (Power power : crucible.getPowerMap().keySet()) {
                if (power.invisible || crucible.getPowerLevel(power) <= max_level) continue;
                max_power = power;
                max_level = crucible.getPowerLevel(power);
            }
            if (max_level > threshold) {
                return this.blockRenderDispatcher.m_110910_(max_power.getRenderBlock().m_49966_()).getParticleIcon(ModelData.EMPTY);
            }
        }
        return this.blockRenderDispatcher.m_110910_(Blocks.f_49990_.m_49966_()).getParticleIcon(ModelData.EMPTY);
    }

    private void renderElectricity(CrucibleBlockEntity crucible) {
        float speedDivisor = 27.0f;
        if (crucible.electricCharge > 0) {
            ParticleScribe.drawParticleCrucibleTop(Objects.requireNonNull(crucible.obtainLevel()), (ParticleOptions)ParticleTypes.f_175830_, crucible.m_58899_(), 0.05f, ((double)crucible.obtainLevel().f_46441_.m_188501_() - 0.5) / (double)speedDivisor, ((double)crucible.obtainLevel().f_46441_.m_188501_() - 0.5) / (double)speedDivisor, ((double)crucible.obtainLevel().f_46441_.m_188501_() - 0.5) / (double)speedDivisor);
        }
    }

    private void renderSculkCharge(CrucibleBlockEntity crucible) {
        float speedDivisor = 27.0f;
        if (!crucible.sculkSpreader.m_222283_().isEmpty()) {
            ParticleScribe.drawParticleCrucibleTop(Objects.requireNonNull(crucible.obtainLevel()), (ParticleOptions)ParticleTypes.f_235898_, crucible.m_58899_(), 0.05f, ((double)crucible.obtainLevel().f_46441_.m_188501_() - 0.5) / (double)speedDivisor, ((double)crucible.obtainLevel().f_46441_.m_188501_() - 0.5) / (double)speedDivisor, ((double)crucible.obtainLevel().f_46441_.m_188501_() - 0.5) / (double)speedDivisor);
        }
    }

    public void render(@NotNull CrucibleBlockEntity crucible, float partialTicks, PoseStack pose_stack, @NotNull MultiBufferSource buffer_source, int light, int overlay) {
        pose_stack.m_85836_();
        pose_stack.m_85837_(0.0, 0.5625, 0.0);
        pose_stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        if (((Boolean)crucible.m_58900_().m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) {
            TextureAtlasSprite sprite = this.getSprite(crucible);
            Color color = crucible.getCombinedColor(BiomeColors.m_108811_((BlockAndTintGetter)((BlockAndTintGetter)Objects.requireNonNull(crucible.obtainLevel())), (BlockPos)crucible.m_58899_()));
            VertexConsumer consumer = buffer_source.m_6299_(Sheets.m_110792_());
            CrucibleRenderer.renderIcon(pose_stack, consumer, sprite, color, crucible.getOpacity(), overlay, light);
            if (crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) > 0) {
                pose_stack.m_85837_(0.0, 0.0, 0.05);
                consumer = buffer_source.m_6299_(RenderType.m_173239_());
                CrucibleRenderer.renderEndPortalWater(pose_stack, consumer, overlay, light);
            }
        }
        pose_stack.m_85849_();
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        this.renderReactions(crucible);
        this.renderElectricity(crucible);
        this.renderSculkCharge(crucible);
    }

    public static void renderIcon(PoseStack ms, VertexConsumer builder, TextureAtlasSprite sprite, Color color, float alpha, int overlay, int light) {
        Matrix4f mat = ms.m_85850_().m_252922_();
        builder.m_252986_(mat, 0.19f, 0.81f, 0.0f).m_6122_(color.red, color.green, color.blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(mat, 0.81f, 0.81f, 0.0f).m_6122_(color.red, color.green, color.blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(mat, 0.81f, 0.19f, 0.0f).m_6122_(color.red, color.green, color.blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(mat, 0.19f, 0.19f, 0.0f).m_6122_(color.red, color.green, color.blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    public static void renderEndPortalWater(PoseStack pose_stack, VertexConsumer consumer, int overlay, int light) {
        Matrix4f pose = pose_stack.m_85850_().m_252922_();
        consumer.m_252986_(pose, 0.19f, 0.81f, 0.0f).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose, 0.81f, 0.81f, 0.0f).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose, 0.81f, 0.19f, 0.0f).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose, 0.19f, 0.19f, 0.0f).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }
}

