/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hyperlynx.reactive.be.GatewayBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import org.jetbrains.annotations.NotNull;

public class GatewayRenderer<T extends GatewayBlockEntity>
implements BlockEntityRenderer<T> {
    BlockEntityRendererProvider.Context context;

    public GatewayRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(@NotNull T gateway, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.renderVolume(gateway, new GatewayRenderContext(bufferSource.m_6299_(RenderType.m_173242_()), poseStack.m_85850_()), partialTick);
    }

    protected void renderVolume(T gateway, GatewayRenderContext context, float partialTick) {
        double time = ((GatewayBlockEntity)((Object)gateway)).totalTick(partialTick);
        float startup_proportion = ((GatewayBlockEntity)((Object)gateway)).startupProportion(partialTick);
        float base_scale = 0.95f * startup_proportion;
        float amplitude = 0.12f * startup_proportion;
        float distortion_1 = (float)(Math.sin(time / 50.0) * (double)amplitude + (double)base_scale);
        float distortion_2 = (float)(Math.sin(time / 55.0) * (double)amplitude + (double)base_scale);
        float distortion_3 = (float)(Math.sin(time / 48.0) * (double)amplitude + (double)base_scale);
        float distortion_4 = (float)(Math.sin(time / 52.0) * (double)amplitude + (double)base_scale);
        float distortion_5 = (float)(Math.sin(time / 50.0 + 0.5) * (double)amplitude + (double)base_scale);
        float distortion_6 = (float)(Math.sin(time / 55.0 + 0.5) * (double)amplitude + (double)base_scale);
        float distortion_7 = (float)(Math.sin(time / 48.0 + 0.5) * (double)amplitude + (double)base_scale);
        float distortion_8 = (float)(Math.sin(time / 52.0 + 0.5) * (double)amplitude + (double)base_scale);
        this.renderFace(context, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, distortion_3, distortion_1, distortion_4, distortion_2);
        this.renderFace(context, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, distortion_7, distortion_5, distortion_6, distortion_8);
        this.renderFace(context, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, distortion_6, distortion_8, distortion_2, distortion_4);
        this.renderFace(context, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, distortion_5, distortion_7, distortion_3, distortion_1);
        this.renderFace(context, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, distortion_1, distortion_7, distortion_2, distortion_6);
        this.renderFace(context, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, distortion_5, distortion_3, distortion_8, distortion_4);
    }

    protected void renderFace(GatewayRenderContext context, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, float ul_distort, float dl_distort, float ur_distort, float dr_distort) {
        context.renderVertex(this.adjust(x0, dl_distort), this.adjust(y0, dl_distort), this.adjust(z0, dl_distort));
        context.renderVertex(this.adjust(x1, dr_distort), this.adjust(y0, dr_distort), this.adjust(z1, dr_distort));
        context.renderVertex(this.adjust(x1, ur_distort), this.adjust(y1, ur_distort), this.adjust(z2, ur_distort));
        context.renderVertex(this.adjust(x0, ul_distort), this.adjust(y1, ul_distort), this.adjust(z3, ul_distort));
    }

    protected float adjust(float base, float distort_factor) {
        float core_dist = base - 0.5f;
        float result_dist = core_dist * distort_factor;
        return result_dist + 0.5f;
    }

    public static class GatewayRenderContext {
        protected VertexConsumer consumer;
        protected PoseStack.Pose pose;

        protected GatewayRenderContext(VertexConsumer consumer, PoseStack.Pose pose) {
            this.consumer = consumer;
            this.pose = pose;
        }

        protected void renderVertex(float x, float y, float z) {
            this.consumer.m_252986_(this.pose.m_252922_(), x, y, z).m_5752_();
        }
    }
}

