/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.client.renderers.rxn.ReactorRenderer;
import dev.hyperlynx.reactive.entities.ReactorEntity;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ReactorEntityRenderer
extends EntityRenderer<ReactorEntity>
implements ReactorRenderer {
    public ReactorEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ReactorEntity reactor, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)reactor, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        assert (Minecraft.m_91087_().f_91073_ != null);
        Map<Power, Integer> powers = reactor.reactorData().powers();
        for (Power power : powers.keySet()) {
            float chance = (float)powers.get(power).intValue() * 2.0f / (float)reactor.maxPower();
            if (!(Minecraft.m_91087_().f_91073_.f_46441_.m_188501_() < chance)) continue;
            ParticleScribe.drawExactParticleSphere(reactor.obtainLevel(), (ParticleOptions)new EnergyParticle.Options(power.getColor(), reactor.m_20182_()), reactor.m_20182_(), 0.0, 0.4, 1);
        }
        this.renderReactions(reactor);
        this.renderCharge(reactor);
    }

    private void renderCharge(ReactorEntity reactor) {
        if (reactor.getElectricCharge() > 0 && reactor.obtainLevel().f_46441_.m_188501_() < 0.03f) {
            ParticleScribe.drawExactParticleSphere(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_175830_, reactor.m_20182_(), 0.0, 0.1, 1);
        }
    }

    public ResourceLocation getTextureLocation(ReactorEntity entity) {
        return null;
    }
}

