/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.renderers.rxn;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionEffects;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.client.renderers.rxn.ReactionRenderer;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.hyperlynx.reactive.net.rxn.ReactionStatusMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;

public class ReactionRenderers {
    public final Map<String, ReactionRenderer> RENDERERS = new HashMap<String, ReactionRenderer>();

    public ReactionRenderers() {
        this.RENDERERS.put("curse_assimilation", this::curseRing);
        this.RENDERERS.put("discharge_annihilation", this::annihilationSmoke);
        this.RENDERERS.put("smoke_annihilation", this::smoke);
        this.RENDERERS.put("growth", this::growth);
        this.RENDERERS.put("flames", this::flamethrower);
        this.RENDERERS.put("astral_curse_annihilation", this::creation);
        this.RENDERERS.put("cryo", this::snow);
        this.RENDERERS.put("nodule", this::warpEnergy);
        this.RENDERERS.put("astral", this::astralRing);
    }

    public static void handleReactionStatusMessage(ReactionStatusMessage message) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Reactor reactor = message.target().getReactor((Level)level);
        if (reactor == null) {
            return;
        }
        reactor.clearRenderReactions();
        for (ReactionStatusEntry entry : message.statuses()) {
            if (entry.status() != Reaction.Status.REACTING) continue;
            reactor.addRenderReaction(entry.reaction_alias());
        }
    }

    public Iterable<ReactionRenderer> getRenderers(Iterable<String> aliases) {
        if (ModList.get().isLoaded("kubejs")) {
            ReactiveKubeJSPlugin.REACTION_EFFECT_CACHE.requestRenderers();
        }
        ArrayList<ReactionRenderer> ret = new ArrayList<ReactionRenderer>();
        for (String alias : aliases) {
            if (!this.RENDERERS.containsKey(alias)) continue;
            ret.add(this.RENDERERS.get(alias));
        }
        return ret;
    }

    public void smoke(Reactor reactor) {
        ParticleScribe.drawParticleReactionSurface(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123755_, reactor, 0.3f);
    }

    public void annihilationSmoke(Reactor reactor) {
        ParticleScribe.drawParticleReactionSurface(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123762_, reactor, 0.2f);
    }

    public void curseRing(Reactor reactor) {
        RandomSource random = reactor.obtainLevel().f_46441_;
        if ((double)random.m_188501_() < 0.3) {
            Vec3 random_offset = new Vec3((double)random.m_188501_() * 0.4 - 0.2, (double)random.m_188501_() * 0.4 - 0.4, (double)random.m_188501_() * 0.4 - 0.2);
            ParticleScribe.drawExactParticleRing(reactor.obtainLevel(), (ParticleOptions)new EnergyParticle.Options(0.05f, ((Power)Powers.CURSE_POWER.get()).getColor(), reactor.getPos(), false, true), reactor.getPos().m_82549_(random_offset), 0.0, 0.7, 1);
        }
    }

    public void astralRing(Reactor reactor) {
        RandomSource random = reactor.obtainLevel().f_46441_;
        if ((double)random.m_188501_() < 0.3) {
            Vec3 random_offset = new Vec3((double)random.m_188501_() * 0.4 - 0.2, (double)random.m_188501_() * 0.4 - 0.4, (double)random.m_188501_() * 0.4 - 0.2);
            ParticleScribe.drawExactParticleRing(reactor.obtainLevel(), (ParticleOptions)new EnergyParticle.Options(0.05f, ((Power)Powers.ASTRAL_POWER.get()).getColor(), reactor.getPos(), true, true), reactor.getPos().m_82549_(random_offset), 0.0, 0.7, 1);
        }
    }

    public void growth(Reactor reactor) {
        ParticleScribe.drawParticleReactionSurface(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123748_, reactor, 0.1f);
    }

    public void flamethrower(Reactor reactor) {
        if (reactor.obtainLevel() == null) {
            return;
        }
        if (reactor.getPowerLevel((Power)Powers.SOUL_POWER.get()) > 20) {
            ParticleScribe.drawParticleReactionSurface(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123745_, reactor, 0.1f, 0.0, 0.1, 0.0);
        } else {
            ParticleScribe.drawParticleReactionSurface(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123744_, reactor, 0.1f, 0.0, 0.1, 0.0);
        }
    }

    public void creation(Reactor reactor) {
        Set<BlockPos> points = ReactionEffects.getCreationPoints(reactor.blockPos());
        for (BlockPos pos : points) {
            if (!reactor.obtainLevel().m_8055_(pos).m_60795_()) continue;
            ParticleScribe.drawParticleSphere(Objects.requireNonNull(reactor.obtainLevel()), (ParticleOptions)Registration.STARDUST_PARTICLE, pos, 0.5, 1.0, 1);
        }
    }

    public void snow(Reactor reactor) {
        AABB aoe = new AABB(reactor.blockPos());
        aoe = aoe.m_82400_(5.0);
        ParticleScribe.drawParticleBox(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_175821_, aoe, 1);
    }

    public void warpEnergy(Reactor reactor) {
        if (reactor.obtainLevel().f_46441_.m_188501_() < 0.2f) {
            ParticleScribe.drawParticleBox(reactor.obtainLevel(), (ParticleOptions)new EnergyParticle.Options(0.1f, ((Power)Powers.WARP_POWER.get()).getColor(), reactor.getPos(), true), AABB.m_165882_((Vec3)reactor.getPos(), (double)1.0, (double)1.0, (double)1.0), 1);
        }
    }
}

