/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.entities;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.items.PhantomQuiltItem;
import dev.hyperlynx.reactive.net.quilt.HoverQuiltHeightMessage;
import dev.hyperlynx.reactive.net.quilt.HoverQuiltVelocityMessage;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoverQuilt
extends Entity {
    public final AnimationState hovering = new AnimationState();
    public long animation_timer = 0L;
    private boolean ridden_last_tick = false;
    private int position_force_timer = 0;
    private boolean client_position_lock = false;
    private static final double MAX_SPEED = 0.25;

    public HoverQuilt(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.hovering.m_216977_(0);
        this.m_20331_(false);
    }

    protected void m_8097_() {
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public double m_6048_() {
        return 0.05;
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity driver = (LivingEntity)entity;
            return driver;
        }
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            ++this.animation_timer;
            if (this.m_20160_() && this.m_6109_()) {
                LivingEntity riding_entity = this.m_6688_();
                if (riding_entity instanceof LocalPlayer) {
                    LocalPlayer rider = (LocalPlayer)riding_entity;
                    float velocity = 0.0f;
                    if (rider.f_108618_.f_108568_ || rider.f_108618_.f_108572_) {
                        velocity = 0.03f;
                    }
                    if (rider.f_108618_.f_108569_) {
                        velocity = -0.03f;
                    }
                    Registration.GENERAL_CHANNEL.sendToServer((Object)new HoverQuiltVelocityMessage(velocity));
                }
                this.client_position_lock = false;
            } else {
                this.client_position_lock = !this.m_20160_();
            }
        } else if (!this.m_20160_()) {
            this.m_20334_(0.0, 0.0, 0.0);
            if (this.ridden_last_tick) {
                this.position_force_timer = 10;
            }
            if (this.position_force_timer > 0) {
                Registration.GENERAL_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new HoverQuiltHeightMessage(this.m_19879_(), this.m_20186_()));
                --this.position_force_timer;
            }
            this.ridden_last_tick = false;
        } else {
            this.ridden_last_tick = true;
            Objects.requireNonNull(this.m_6688_()).m_183634_();
        }
        if (this.isHittingRidersHead()) {
            this.m_20334_(0.0, Math.min(-0.05, -this.m_20184_().f_82480_), 0.0);
        } else if (this.isHittingRidersButt()) {
            this.m_20334_(0.0, Math.max(0.05, -this.m_20184_().f_82480_), 0.0);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    private boolean isHittingRidersHead() {
        if (!this.m_20160_()) {
            return false;
        }
        LivingEntity passenger = this.m_6688_();
        if (passenger == null) {
            return false;
        }
        AABB passenger_hitbox = passenger.m_20191_();
        double passenger_width = passenger_hitbox.m_82362_();
        AABB passenger_top_box = new AABB(passenger_hitbox.f_82291_ - passenger_width, passenger_hitbox.f_82292_ - 1.0, passenger_hitbox.f_82293_ - passenger_width, passenger_hitbox.f_82291_, passenger_hitbox.f_82292_ + 0.1, passenger_hitbox.f_82293_);
        return this.m_9236_().m_186434_((Entity)this, passenger_top_box).iterator().hasNext();
    }

    private boolean isHittingRidersButt() {
        if (!this.m_20160_()) {
            return false;
        }
        LivingEntity passenger = this.m_6688_();
        if (passenger == null) {
            return false;
        }
        AABB passenger_hitbox = passenger.m_20191_();
        double passenger_width = passenger_hitbox.m_82362_();
        AABB passenger_below_box = new AABB(passenger_hitbox.f_82288_, passenger_hitbox.f_82289_, passenger_hitbox.f_82290_, passenger_hitbox.f_82288_ + passenger_width, passenger_hitbox.f_82289_ + 1.0, passenger_hitbox.f_82290_ + passenger_width);
        return this.m_9236_().m_186434_((Entity)this, passenger_below_box).iterator().hasNext();
    }

    private double getMaxUpSpeed() {
        double current_height = this.m_20182_().f_82480_;
        double max_world_height = this.m_9236_().m_151558_();
        if (current_height > max_world_height) {
            if (current_height - max_world_height > 10.0) {
                return 0.0;
            }
            return 0.25 * (1.0 / (current_height - max_world_height + 1.0));
        }
        return 0.25;
    }

    private double getMaxDownSpeed() {
        double current_height = this.m_20182_().f_82480_;
        double min_world_height = this.m_9236_().m_141937_();
        if (current_height < min_world_height) {
            if (current_height - min_world_height < -5.0) {
                return 0.0;
            }
            return -0.25 * (1.0 / (min_world_height - current_height + 1.0));
        }
        return -0.25;
    }

    public static void handleInputPacket(HoverQuiltVelocityMessage payload, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getSender() == null) {
                return;
            }
            Entity vehicle = Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender()).m_20202_();
            if (vehicle instanceof HoverQuilt) {
                HoverQuilt quilt = (HoverQuilt)vehicle;
                double unadjusted_y_vel = payload.velocity() + quilt.m_20184_().f_82480_;
                double clamped_y_vel = Math.min(Math.max(unadjusted_y_vel, quilt.getMaxDownSpeed()), quilt.getMaxUpSpeed());
                quilt.m_20334_(0.0, clamped_y_vel, 0.0);
            }
        });
        context.get().setPacketHandled(true);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult super_interaction_result = super.m_6096_(player, hand);
        if (super_interaction_result != InteractionResult.PASS) {
            return super_interaction_result;
        }
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        return super.m_7688_(passenger);
    }

    public static void handleHeightUpdate(HoverQuiltHeightMessage payload, Level level) {
        Entity vehicle = level.m_6815_(payload.id());
        if (vehicle instanceof HoverQuilt) {
            HoverQuilt quilt = (HoverQuilt)vehicle;
            quilt.client_position_lock = false;
            quilt.m_6034_(quilt.m_20185_(), payload.height(), quilt.m_20189_());
            quilt.client_position_lock = true;
            quilt.m_20334_(0.0, 0.0, 0.0);
            quilt.m_146867_();
            quilt.m_6453_(quilt.m_20185_(), payload.height(), quilt.m_20189_(), quilt.m_146908_(), quilt.m_146909_(), 1, false);
        }
    }

    public void m_6034_(double x, double y, double z) {
        if (this.client_position_lock) {
            return;
        }
        super.m_6034_(x, y, z);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((PhantomQuiltItem)((Object)Registration.PHANTOM_QUILT_ITEM.get())).m_7968_()));
        this.m_6074_();
        return true;
    }
}

