/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.entities;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;

public record ReactorData(Map<Power, Integer> powers, List<ReactionStatusEntry> statuses) {
    private static final String POWERS_TAG = "Powers";
    private static final String STATUSES_TAG = "Statuses";

    public CompoundTag toTag() {
        ListTag power_list = Power.writePowerLevelMap(this.powers);
        ListTag status_list = new ListTag();
        for (ReactionStatusEntry status : this.statuses) {
            CompoundTag status_tag = new CompoundTag();
            status_tag.m_128359_("s", status.getStatusAsString());
            status_tag.m_128359_("r", status.reaction_alias());
            status_list.add((Object)status_tag);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(POWERS_TAG, (Tag)power_list);
        tag.m_128365_(STATUSES_TAG, (Tag)status_list);
        return tag;
    }

    public static ReactorData fromTag(CompoundTag tag) {
        ListTag power_list = tag.m_128437_(POWERS_TAG, 10);
        Map<Power, Integer> powers = Power.readPowerLevelMap(power_list);
        ListTag status_list = tag.m_128437_(STATUSES_TAG, 10);
        ArrayList<ReactionStatusEntry> entries = new ArrayList<ReactionStatusEntry>();
        for (Tag status_t : status_list) {
            if (!(status_t instanceof CompoundTag)) continue;
            CompoundTag status_tag = (CompoundTag)status_t;
            entries.add(new ReactionStatusEntry(Reaction.Status.valueOf(status_tag.m_128461_("s")), status_tag.m_128461_("r")));
        }
        return new ReactorData(powers, entries);
    }

    public ReactorData copy() {
        return new ReactorData(new HashMap<Power, Integer>(this.powers), new ArrayList<ReactionStatusEntry>(this.statuses));
    }

    public static class Serializer
    implements EntityDataSerializer<ReactorData> {
        public void write(FriendlyByteBuf buf, ReactorData data) {
            buf.m_130079_(data.toTag());
        }

        public ReactorData read(FriendlyByteBuf buf) {
            CompoundTag tag = buf.m_130260_();
            return ReactorData.fromTag(tag);
        }

        public ReactorData copy(ReactorData value) {
            return new ReactorData(value.powers(), value.statuses());
        }
    }
}

