/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei.bottles;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.integration.jei.bottles.PowerBottleRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerBottleRecipeSerializer
implements RecipeSerializer<PowerBottleRecipe> {
    @NotNull
    public PowerBottleRecipe fromJson(@NotNull ResourceLocation id, JsonObject json) {
        try {
            JsonElement power_element = json.get("power");
            RegistryObject powObj = RegistryObject.create((ResourceLocation)ResourceLocation.m_135820_((String)power_element.getAsString()), Powers.POWER_SUPPLIER.get());
            return new PowerBottleRecipe(id, "power_bottle", (Power)powObj.get());
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    @Nullable
    public PowerBottleRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
        Power power = (Power)buffer.readRegistryId();
        return new PowerBottleRecipe(id, "power_bottle", power);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull PowerBottleRecipe recipe) {
        buffer.writeRegistryId(Powers.POWER_SUPPLIER.get(), (Object)recipe.power);
    }
}

