/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs.events;

import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.hyperlynx.reactive.integration.kubejs.events.CustomReactionTickEventJS;
import dev.hyperlynx.reactive.integration.kubejs.events.EventTransceiver;
import dev.hyperlynx.reactive.integration.kubejs.net.CustomReactionAliasRequest;
import dev.latvian.mods.kubejs.event.EventExit;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.IEventHandler;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.network.PacketDistributor;

public class EventHandlerCache {
    private final List<IEventHandler> reaction_runners = new ArrayList<IEventHandler>();
    private final List<IEventHandler> server_reaction_tests = new ArrayList<IEventHandler>();
    public boolean received_renderers = false;
    private Instant last_request_timestamp;

    public void ingestReactionHandlers() {
        EventTransceiver.CUSTOM_REACTION_RUN_EVENT.forEachListener(ScriptType.SERVER, container -> this.reaction_runners.add(container.handler));
        EventTransceiver.CUSTOM_REACTION_TEST_CONDITIONS_EVENT.forEachListener(ScriptType.SERVER, container -> this.server_reaction_tests.add(container.handler));
    }

    public void resetReactionHandlers() {
        this.reaction_runners.clear();
        this.server_reaction_tests.clear();
    }

    private EventResult processEvent(EventJS event, List<IEventHandler> handlers) {
        Iterator<IEventHandler> iterator = handlers.iterator();
        if (iterator.hasNext()) {
            IEventHandler handler = iterator.next();
            try {
                handler.onEvent(event);
                return EventResult.PASS;
            }
            catch (EventExit exit) {
                return exit.result;
            }
        }
        return EventResult.PASS;
    }

    public EventResult processServerTestEvent(CustomReactionTickEventJS event) {
        return this.processEvent(event, this.server_reaction_tests);
    }

    public EventResult processRunEvent(CustomReactionTickEventJS event) {
        return this.processEvent(event, this.reaction_runners);
    }

    public void requestRenderers() {
        if (this.received_renderers) {
            return;
        }
        if (this.last_request_timestamp == null || this.last_request_timestamp.isBefore(Instant.now().minus(10L, ChronoUnit.SECONDS))) {
            ReactiveKubeJSPlugin.LOGGER.info("Requesting KubeJS reaction aliases");
            ReactiveKubeJSPlugin.KUBEJS_INTEGRATION_CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new CustomReactionAliasRequest());
            this.last_request_timestamp = Instant.now();
        }
    }
}

