/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.patchouli;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.YieldEntry;
import dev.hyperlynx.reactive.alchemy.material.formula.MaterialFormulaMaps;
import dev.hyperlynx.reactive.items.MaterialItem;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class MaterialCraftComponentProcessor
implements IComponentProcessor {
    private ItemStack base = ItemStack.f_41583_;
    private ItemStack result = ItemStack.f_41583_;

    public void setup(Level level, IVariableProvider variables) {
        this.base = (ItemStack)variables.get("base").as(ItemStack.class);
        String output_material_id = variables.get("output_material").asString();
        ResourceLocation output_material_rl = ResourceLocation.parse((String)output_material_id);
        if (MaterialMan.occupied(level, output_material_rl)) {
            this.result = ((MaterialItem)((Object)Registration.MATERIAL_ITEM.get())).m_7968_();
            MaterialItem.setMaterialId(this.result, output_material_rl);
            YieldEntry yield = MaterialFormulaMaps.BASE_YIELDS.get(this.base.m_41720_().m_204114_().m_205785_().m_135782_());
            if (yield != null) {
                this.result.m_41764_(this.base.m_41613_() * yield.yield_per_input());
            }
        }
    }

    @Nullable
    public IVariable process(Level level, @NotNull String key) {
        switch (key) {
            case "reactant": {
                return IVariable.from((Object)this.base);
            }
            case "product": {
                return IVariable.from((Object)this.result);
            }
            case "info": {
                if (this.base == ItemStack.f_41583_) {
                    return IVariable.wrap((String)Component.m_237115_((String)"docs.reactive.invalid_base_material").getString());
                }
                if (this.result != ItemStack.f_41583_) break;
                return IVariable.wrap((String)Component.m_237115_((String)"docs.reactive.invalid_material").getString());
            }
        }
        return null;
    }
}

