/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.patchouli;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.material.FlagMaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.MaterialFormulaMaps;
import dev.hyperlynx.reactive.alchemy.material.formula.PropertyFormulaRequirements;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class MaterialPropertyComponentProcessor
implements IComponentProcessor {
    ResourceLocation property_id = ReactiveMod.location("error");

    public void setup(Level level, IVariableProvider variables) {
        this.property_id = ResourceLocation.parse((String)variables.get("property").asString());
    }

    @Nullable
    public IVariable process(Level level, String key) {
        if (key.equals("formula")) {
            PropertyFormulaRequirements data = MaterialFormulaMaps.PROPERTY_FORMULA_MAP.get(this.property_id);
            if (data == null) {
                ReactiveMod.LOGGER.error("Couldn't load formula data maps in level {}", (Object)level);
                return IVariable.wrap((String)"$(4)No formula data map could be loaded.");
            }
            List<PropertyFormulaRequirements.Part> requirements = data.requirements();
            StringBuilder formula = new StringBuilder();
            if (!requirements.isEmpty()) {
                formula.append(Component.m_237115_((String)"docs.reactive.formula_label").getString());
                requirements.forEach(requirement -> {
                    formula.append(Component.m_237115_((String)"docs.reactive.at_least").getString());
                    int percent = requirement.lowBound(this.property_id) / 16;
                    formula.append((String)(percent >= 1 ? percent + "% " : Component.m_237115_((String)"docs.reactive.trace").getString()));
                    formula.append(Component.m_237115_((String)requirement.power_id().m_214296_("power")).getString());
                    formula.append("$(br)");
                });
                formula.append("$(br)");
            }
            if (!(this.property() instanceof FlagMaterialProperty)) {
                List<FormulaOutcome> outcomes = MaterialFormulaMaps.FORMULA_OUTCOME_MAP.get(this.property_id);
                formula.append(Component.m_237115_((String)"docs.reactive.outcome_label").getString());
                outcomes.forEach(outcome -> {
                    ResourceLocation power_id = outcome.power();
                    if (power_id != null) {
                        formula.append(Component.m_237115_((String)power_id.m_214296_("power")).getString());
                        formula.append("$(br)");
                    }
                });
            }
            return IVariable.wrap((String)formula.toString());
        }
        return null;
    }

    private MaterialProperty<?> property() {
        @Nullable MaterialProperty property = (MaterialProperty)MaterialProperties.PROPERTY_SUPPLIER.get().getValue(this.property_id);
        if (property == null) {
            throw new NoSuchElementException("No material property with id " + this.property_id);
        }
        return property;
    }
}

