/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.PowerBottleInsertContext;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public interface BasePowerBottle {
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_6115_(BlockSource source, ItemStack stack) {
            BlockPos target = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            if (!(source.m_7727_().m_8055_(target).m_60734_() instanceof CrucibleBlock)) {
                return this.defaultDispenseItemBehavior.m_6115_(source, stack);
            }
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)source.m_7727_().m_7702_(target);
            if (crucible == null) {
                return this.defaultDispenseItemBehavior.m_6115_(source, stack);
            }
            boolean changed = false;
            for (Power p : Powers.POWER_SUPPLIER.get()) {
                if (!p.matchesBottle(stack) || !crucible.addPower(p, WorldSpecificValues.BOTTLE_RETURN.get())) continue;
                if (stack.m_150930_((Item)Registration.WARP_BOTTLE.get()) && WarpBottleItem.isRiftBottle(stack)) {
                    crucible.enderRiftStrength = 2000;
                }
                stack.m_41774_(1);
                ItemEntity quartz_bottle_drop = new ItemEntity((Level)source.m_7727_(), (double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.6, (double)target.m_123343_() + 0.5, ((Item)Registration.QUARTZ_BOTTLE.get()).m_7968_());
                source.m_7727_().m_7967_((Entity)quartz_bottle_drop);
                changed = true;
            }
            if (changed) {
                crucible.setDirty();
                crucible.obtainLevel().m_5594_(null, crucible.m_58899_(), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.65f + crucible.obtainLevel().m_213780_().m_188501_() / 5.0f);
            }
            return stack;
        }
    };

    default public InteractionResult tryAddToCrucible(UseOnContext context) {
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)context.m_43725_().m_7702_(context.m_8083_());
        if (crucible == null) {
            return InteractionResult.PASS;
        }
        CrucibleBlockEntity.insertPowerBottle(crucible, new PowerBottleInsertContext(context));
        return InteractionResult.SUCCESS;
    }
}

