/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.blocks.ChainDisplacingBlock;
import dev.hyperlynx.reactive.blocks.DisplacedBlock;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class DisplacerItem
extends Item {
    public static final int DISPLACER_BASE_DISPLACE_TIME = 200;

    public DisplacerItem(Item.Properties props) {
        super(props);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        double ATTACK_DAMAGE = 3.5;
        double ATTACK_SPEED = -3.0;
        ImmutableMultimap.Builder mainhand_modifier_builder = ImmutableMultimap.builder();
        mainhand_modifier_builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", ATTACK_DAMAGE, AttributeModifier.Operation.ADDITION));
        mainhand_modifier_builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", ATTACK_SPEED, AttributeModifier.Operation.ADDITION));
        return slot == EquipmentSlot.MAINHAND ? mainhand_modifier_builder.build() : super.m_7167_(slot);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        boolean hyper_mode;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        level.m_220407_(GameEvent.f_157770_, context.m_8083_(), GameEvent.Context.m_223722_((BlockState)context.m_43725_().m_8055_(context.m_8083_())));
        boolean bl = hyper_mode = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)Registration.WORLD_PIERCER.get()), (LivingEntity)((LivingEntity)Objects.requireNonNull(context.m_43723_()))) > 0;
        if (hyper_mode) {
            Optional<BlockPos> displaced_center = this.perform(context, level, pos, state, 32, 400);
            if (displaced_center.isPresent()) {
                Direction.Axis perpendicular_axis = switch (context.m_43719_().m_122434_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.Axis.X, Direction.Axis.Z -> Direction.Axis.Y;
                    case Direction.Axis.Y -> Direction.Axis.X;
                };
                Direction initial_direction = context.m_43719_().m_175362_(perpendicular_axis);
                int extra_delay = 0;
                for (BlockPos pos_within_square : BlockPos.m_121935_((BlockPos)displaced_center.get(), (int)1, (Direction)context.m_43719_().m_175362_(initial_direction.m_122434_()), (Direction)initial_direction)) {
                    if (pos_within_square == displaced_center.get()) continue;
                    DisplacedBlock.displaceWithChain(level.m_8055_(pos_within_square), pos_within_square, level, 2 + extra_delay, 1, pos);
                    ++extra_delay;
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (this.perform(context, level, pos, state, 8, 200).isPresent()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private Optional<BlockPos> perform(UseOnContext context, Level level, BlockPos pos, BlockState state, int max_depth, int displace_time) {
        if (state.m_60734_() instanceof DisplacedBlock) {
            if (context.m_43721_()) {
                if (context.m_43723_() != null && context.m_43723_().m_146909_() > 20.0f && !context.m_43719_().equals((Object)Direction.UP)) {
                    pos = pos.m_7495_();
                }
                if (context.m_43723_() != null && context.m_43723_().m_146909_() < -20.0f && !context.m_43719_().equals((Object)Direction.DOWN)) {
                    pos = pos.m_7494_();
                }
            }
            BlockPos selected = pos;
            for (int i = 0; i < max_depth; ++i) {
                if (level.m_8055_(selected = selected.m_121955_(context.m_43719_().m_122424_().m_122436_())).m_60734_() instanceof DisplacedBlock) continue;
                DisplacerItem.displace(level, selected, displace_time);
                Player player = context.m_43723_();
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer splayer = (ServerPlayer)player;
                if (context.m_43723_().m_7500_()) break;
                context.m_43722_().m_41622_(1, (LivingEntity)splayer, l -> {});
                break;
            }
            level.m_5594_(null, pos, state.m_60734_().getSoundType(state, (LevelReader)level, pos, null).m_56778_(), SoundSource.PLAYERS, 1.0f, 1.1f);
            return Optional.of(selected);
        }
        boolean displace_worked = DisplacerItem.displace(level, pos, displace_time);
        if (displace_worked) {
            level.m_5594_(null, pos, state.m_60734_().getSoundType(state, (LevelReader)level, pos, null).m_56778_(), SoundSource.PLAYERS, 1.0f, 1.0f);
            Player player = context.m_43723_();
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                if (!context.m_43723_().m_7500_()) {
                    context.m_43722_().m_41622_(1, (LivingEntity)splayer, l -> {});
                }
            }
            return Optional.of(pos);
        }
        level.m_5594_(null, pos, state.m_60734_().getSoundType(state, (LevelReader)level, pos, null).m_56778_(), SoundSource.PLAYERS, 1.0f, 0.7f);
        return Optional.empty();
    }

    private static boolean displace(Level level, BlockPos selected, int displace_time) {
        Block block = level.m_8055_(selected).m_60734_();
        if (block instanceof ChainDisplacingBlock) {
            ChainDisplacingBlock cdb = (ChainDisplacingBlock)block;
            cdb.breadthFirstDisplace(level, selected, level.m_277086_(selected) > 0, displace_time);
            return true;
        }
        return DisplacedBlock.displace(level.m_8055_(selected), selected, level, displace_time);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity victim, LivingEntity wielder) {
        stack.m_41622_(2, wielder, living -> living.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public boolean m_6832_(ItemStack self, ItemStack repair_item_candidate) {
        return repair_item_candidate.m_150930_((Item)Registration.MOTION_SALT.get());
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 10;
    }
}

