/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.entities.ThrownReactionFlask;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ReactionFlaskItem
extends Item {
    public ReactionFlaskItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            ThrownReactionFlask flask = new ThrownReactionFlask(Registration.THROWN_REACTION_FLASK.get(), level);
            flask.m_6034_(player.m_20185_(), player.m_20188_() - (double)0.1f, player.m_20189_());
            flask.m_5602_((Entity)player);
            flask.m_37446_(stack);
            flask.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.5f, 1.0f);
            level.m_7967_((Entity)flask);
            CriteriaTriggers.THROW_FLASK.trigger((ServerPlayer)player);
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> hover_text, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, hover_text, tooltipFlag);
        if (!Contents.hasContents(stack)) {
            hover_text.add((Component)Component.m_237115_((String)"text.reactive.random").m_130940_(ChatFormatting.LIGHT_PURPLE));
            return;
        }
        Contents contents = Contents.getFromStack(stack);
        assert (contents != null);
        MutableComponent power_readout = Component.m_237119_();
        int counter = 0;
        Set<Power> powers = contents.powers().keySet();
        for (Power power : powers) {
            power_readout.m_7220_((Component)Component.m_237113_((String)power.getName()).m_130948_(Style.f_131099_.m_178520_(power.getColor().hex())));
            if (++counter == powers.size()) continue;
            power_readout.m_130946_(" + ");
        }
        if (!power_readout.m_7360_().isEmpty()) {
            hover_text.add((Component)power_readout);
        }
        if (contents.electric_charge()) {
            hover_text.add((Component)Component.m_237115_((String)"text.reactive.charged"));
        }
    }

    public record Contents(Map<Power, Integer> powers, boolean electric_charge) {
        private static final String CONTENT_TAG = "FlaskContents";

        public static boolean hasContents(ItemStack stack) {
            return stack.m_41782_() && stack.m_41784_().m_128441_(CONTENT_TAG);
        }

        @Nullable
        public static Contents getFromStack(ItemStack stack) {
            if (!Contents.hasContents(stack)) {
                return null;
            }
            assert (stack.m_41783_() != null);
            CompoundTag tag = stack.m_41783_().m_128469_(CONTENT_TAG);
            Map<Power, Integer> powers = Power.readPowerLevelMap(tag.m_128437_("Powers", 10));
            return new Contents(powers, tag.m_128471_("Charged"));
        }

        public void saveToStack(ItemStack stack) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Powers", (Tag)Power.writePowerLevelMap(this.powers));
            tag.m_128379_("Charged", this.electric_charge);
            stack.m_41784_().m_128365_(CONTENT_TAG, (Tag)tag);
        }
    }
}

