/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.enchants.FastStaffEnchantment;
import dev.hyperlynx.reactive.enchants.StrongStaffEnchantment;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class StaffItem
extends BlockItem {
    Consumer<Player> effectFunction;
    boolean beam;
    Supplier<Integer> frequency;
    public Item repair_item;

    public StaffItem(Block block, Item.Properties props, Consumer<Player> effect, boolean beam, Supplier<Integer> frequency, Item repair_item) {
        super(block, props);
        this.effectFunction = effect;
        this.beam = beam;
        this.repair_item = repair_item;
        this.frequency = frequency;
    }

    public static boolean onLastDurability(ItemStack stack) {
        return stack.m_41773_() == stack.m_41776_() - 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int ticks) {
        if (StaffItem.onLastDurability(stack)) {
            return;
        }
        if (ticks % this.getFrequency(stack) == 1) {
            if (level.f_46443_ && !this.beam) {
                this.effectFunction.accept((Player)player);
            }
            if (!level.f_46443_) {
                level.m_214171_(GameEvent.f_157778_, player.m_146892_(), GameEvent.Context.m_223717_((Entity)player));
                this.effectFunction.accept((Player)player);
                if (player.m_21206_().m_150930_(stack.m_41720_())) {
                    player.m_21206_().m_41622_(1, player, l -> {});
                } else {
                    player.m_21205_().m_41622_(1, player, l -> {});
                }
            }
        }
        if (level.f_46443_ && this.beam) {
            this.effectFunction.accept((Player)player);
        }
    }

    private int getFrequency(@NotNull ItemStack stack) {
        int base_frequency = this.frequency.get();
        int enchant_level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)Registration.FAST_STAFF.get()), (ItemStack)stack);
        if (enchant_level > 0) {
            return FastStaffEnchantment.adjustStaffTick(base_frequency, enchant_level);
        }
        return base_frequency;
    }

    public static float getDamageAmount(LivingEntity user, float base_damage) {
        int enchant_level = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)Registration.POTENCY.get()), (LivingEntity)user);
        if (enchant_level > 0) {
            return StrongStaffEnchantment.adjustStaffPower(base_damage, enchant_level);
        }
        return base_damage;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 20;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (StaffItem.onLastDurability(player.m_21120_(hand))) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        if (!player.m_6047_()) {
            player.m_6672_(hand);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.SUCCESS;
        }
        if (context.m_43723_().m_6047_()) {
            return super.m_6225_(context);
        }
        return InteractionResult.PASS;
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public boolean m_6832_(ItemStack self, ItemStack repair_item_candidate) {
        return this.repair_item != null && repair_item_candidate.m_150930_(this.repair_item);
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player placer, ItemStack stack, BlockState state) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return false;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity == null) {
            return false;
        }
        CompoundTag data_tag = blockentity.m_187482_();
        CompoundTag prior_data_tag = data_tag.m_6426_();
        data_tag.m_128365_("ItemTags", (Tag)(stack.m_41782_() ? (Tag)Objects.requireNonNull(stack.m_41783_()) : new CompoundTag()));
        if (!data_tag.equals((Object)prior_data_tag)) {
            blockentity.m_142466_(data_tag);
            blockentity.m_6596_();
            return true;
        }
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }
}

