/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.net.rxn;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.net.rxn.ReactionPageServer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ReactionPageFetcher {
    private static final ConcurrentMap<String, Semaphore> REQUEST_BLOCKERS = new ConcurrentHashMap<String, Semaphore>();
    private static final ConcurrentMap<String, String> RESPONSES = new ConcurrentHashMap<String, String>();

    public static String requestFormulaFor(String alias) throws InterruptedException {
        boolean success;
        if (RESPONSES.containsKey(alias)) {
            return (String)RESPONSES.get(alias);
        }
        Registration.REACTION_SYNC_CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new ReactionFormulaRequest(alias));
        ReactiveMod.LOGGER.debug("Requested formula for {}", (Object)alias);
        if (!REQUEST_BLOCKERS.containsKey(alias)) {
            REQUEST_BLOCKERS.put(alias, new Semaphore(0, false));
        }
        if (!(success = ((Semaphore)REQUEST_BLOCKERS.get(alias)).tryAcquire(1L, TimeUnit.SECONDS))) {
            ReactiveMod.LOGGER.error("Timeout loading contents for the reaction formula for {}", (Object)alias);
            return "$(4) Timeout while loading";
        }
        return (String)RESPONSES.get(alias);
    }

    public static void handleFormulaResponse(ReactionPageServer.ReactionFormulaResponse payload, Supplier<NetworkEvent.Context> context) {
        ReactiveMod.LOGGER.debug("Received response for page about {}", (Object)payload.alias());
        RESPONSES.put(payload.alias(), payload.formula());
        if (!REQUEST_BLOCKERS.containsKey(payload.alias())) {
            REQUEST_BLOCKERS.put(payload.alias(), new Semaphore(0, false));
        }
        ((Semaphore)REQUEST_BLOCKERS.get(payload.alias())).release();
        context.get().setPacketHandled(true);
    }

    public record ReactionFormulaRequest(String alias) {
        public void encoder(FriendlyByteBuf buf) {
            buf.m_130070_(this.alias);
        }

        public static ReactionFormulaRequest decoder(FriendlyByteBuf buf) {
            String alias = buf.m_130277_();
            return new ReactionFormulaRequest(alias);
        }
    }
}

