/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.net.rxn;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.CatalystEffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.CurseAssimilationReaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.net.rxn.ReactionPageFetcher;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ReactionPageServer {
    public static void handlePageRequest(ReactionPageFetcher.ReactionFormulaRequest request, Supplier<NetworkEvent.Context> context) {
        String page = ReactionPageServer.makePageFor(context.get().getSender().m_9236_(), request.alias());
        ReactiveMod.LOGGER.debug("Sending formula for {} to {}", (Object)request.alias(), (Object)context.get().getSender().m_7755_().getString());
        Registration.REACTION_SYNC_CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context.get()).getSender()), (Object)new ReactionFormulaResponse(request.alias(), page));
        context.get().setPacketHandled(true);
    }

    public static String makePageFor(Level level, String alias) {
        Reaction reaction = ReactiveMod.REACTION_MAN.get(alias);
        StringBuilder formula = new StringBuilder();
        if (reaction != null) {
            formula.append(Component.m_237115_((String)"docs.reactive.powers_label").getString());
            for (Power power : reaction.getReagents().keySet()) {
                formula.append(power.getName()).append("$(br)");
            }
            if (reaction instanceof CurseAssimilationReaction) {
                formula.append(Component.m_237115_((String)"docs.reactive.curse_label").getString());
            }
            if (reaction.getReagents().isEmpty()) {
                formula.append(Component.m_237115_((String)"docs.reactive.any_label").getString());
            }
            formula.append(Component.m_237115_((String)"docs.reactive.stimulus_label").getString());
            switch (reaction.getStimulus()) {
                case NONE: {
                    formula.append(Component.m_237115_((String)"text.reactive.none").getString());
                    break;
                }
                case GOLD_SYMBOL: {
                    formula.append(Component.m_237115_((String)"block.reactive.gold_symbol").getString());
                    break;
                }
                case ELECTRIC: {
                    formula.append(Component.m_237115_((String)"text.reactive.electric_charge").getString());
                    break;
                }
                case END_CRYSTAL: {
                    formula.append(Component.m_237115_((String)"item.minecraft.end_crystal").getString());
                    break;
                }
                case NO_ELECTRIC: {
                    formula.append(Component.m_237115_((String)"text.reactive.lack_of").getString()).append(Component.m_237115_((String)"text.reactive.electric_charge").getString());
                    break;
                }
                case NO_END_CRYSTAL: {
                    formula.append(Component.m_237115_((String)"text.reactive.lack_of").getString()).append(Component.m_237115_((String)"item.minecraft.end_crystal").getString());
                }
            }
            if (reaction instanceof CatalystEffectReaction) {
                CatalystEffectReaction catre = (CatalystEffectReaction)reaction;
                formula.append(Component.m_237115_((String)"docs.reactive.catalyst_label").getString());
                formula.append(catre.getCatalyst().m_41466_().getString());
            }
        }
        return formula.toString();
    }

    public record ReactionFormulaResponse(String alias, String formula) {
        public void encoder(FriendlyByteBuf buf) {
            buf.m_130070_(this.alias);
            buf.m_130070_(this.formula);
        }

        public static ReactionFormulaResponse decoder(FriendlyByteBuf buf) {
            String alias = buf.m_130277_();
            String formula = buf.m_130277_();
            return new ReactionFormulaResponse(alias, formula);
        }
    }
}

