/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.net.rxn;

import com.mojang.datafixers.util.Either;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.client.renderers.rxn.ReactionRenderers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public record ReactionStatusMessage(Target target, List<ReactionStatusEntry> statuses) {
    public ReactionStatusMessage(BlockPos pos, List<ReactionStatusEntry> statuses) {
        this(new Target((Either<BlockPos, Integer>)Either.left((Object)pos)), statuses);
    }

    public ReactionStatusMessage(int entity_index, List<ReactionStatusEntry> statuses) {
        this(new Target((Either<BlockPos, Integer>)Either.right((Object)entity_index)), statuses);
    }

    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.target.isBlockEntity());
        if (this.target.isBlockEntity()) {
            buffer.m_130064_(Objects.requireNonNull(this.target.blockEntityReactorPos()));
        } else {
            buffer.writeInt(Objects.requireNonNull(this.target.entityReactorIndex()).intValue());
        }
        buffer.m_236828_(this.statuses, (buf, status) -> {
            buf.m_130070_(status.reaction_alias());
            buf.m_130068_((Enum)status.status());
        });
    }

    public static ReactionStatusMessage decoder(FriendlyByteBuf buffer) {
        boolean target_is_block = buffer.readBoolean();
        Target target = target_is_block ? new Target((Either<BlockPos, Integer>)Either.left((Object)buffer.m_130135_())) : new Target((Either<BlockPos, Integer>)Either.right((Object)buffer.readInt()));
        ArrayList statuses = (ArrayList)buffer.m_236838_(ArrayList::new, buf -> {
            String alias = buf.m_130277_();
            Reaction.Status status = (Reaction.Status)buf.m_130066_(Reaction.Status.class);
            return new ReactionStatusEntry(status, alias);
        });
        return new ReactionStatusMessage(target, (List<ReactionStatusEntry>)statuses);
    }

    public void handler(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ReactionRenderers.handleReactionStatusMessage(this);
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }

    public static class Target {
        private final Either<BlockPos, Integer> target;

        public Target(Either<BlockPos, Integer> target) {
            this.target = target;
        }

        public boolean isBlockEntity() {
            return this.target.left().isPresent();
        }

        @Nullable
        public BlockPos blockEntityReactorPos() {
            return this.target.left().orElse(null);
        }

        @Nullable
        public Integer entityReactorIndex() {
            return this.target.right().orElse(null);
        }

        @Nullable
        public Reactor getReactor(Level level) {
            if (this.target.left().isPresent()) {
                BlockEntity be = level.m_7702_((BlockPos)this.target.left().get());
                if (!(be instanceof Reactor)) {
                    ReactiveMod.LOGGER.error("Sent reaction status to invalid reactor block entity. Ignoring.");
                    return null;
                }
                Reactor reactor = (Reactor)be;
                return reactor;
            }
            if (this.target.right().isPresent()) {
                Entity entity = level.m_6815_(((Integer)this.target.right().get()).intValue());
                if (!(entity instanceof Reactor)) {
                    ReactiveMod.LOGGER.error("Sent reaction status to invalid entity. Ignoring.");
                    return null;
                }
                Reactor reactor = (Reactor)entity;
                return reactor;
            }
            ReactiveMod.LOGGER.error("Sent malformed reaction status. Ignoring.");
            return null;
        }
    }
}

