/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.hyperlynx.reactive.recipes.DissolveRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DissolveRecipeSerializer
implements RecipeSerializer<DissolveRecipe> {
    @NotNull
    public DissolveRecipe fromJson(@NotNull ResourceLocation id, JsonObject json) {
        try {
            Ingredient reactant = CraftingHelper.getIngredient((JsonElement)json.get("reactant").getAsJsonObject(), (boolean)false);
            ItemStack product = CraftingHelper.getItemStack((JsonObject)json.get("product").getAsJsonObject(), (boolean)false);
            boolean needs_electricity = false;
            if (json.has("needs_electricity")) {
                needs_electricity = json.get("needs_electricity").getAsBoolean();
            }
            return new DissolveRecipe(id, "dissolve", reactant, product, needs_electricity);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    @Nullable
    public DissolveRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
        Ingredient reactant = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack product = buffer.m_130267_();
        boolean needs_electricity = buffer.readBoolean();
        return new DissolveRecipe(id, "dissolve", reactant, product, needs_electricity);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull DissolveRecipe recipe) {
        recipe.getReactant().m_43923_(buffer);
        buffer.m_130055_(recipe.product);
        buffer.writeBoolean(recipe.needs_electricity);
    }
}

