/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.items.ReactionFlaskItem;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ReactionFlaskModifyRecipe
extends CustomRecipe {
    public ReactionFlaskModifyRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer input, @NotNull Level level) {
        boolean has_reaction_flask = false;
        boolean has_volt_cell = false;
        boolean has_duplicate_items = false;
        for (ItemStack stack : input.m_280657_()) {
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)Registration.REACTION_FLASK_ITEM.get()) && ReactionFlaskItem.Contents.hasContents(stack)) {
                if (has_reaction_flask) {
                    has_duplicate_items = true;
                } else {
                    has_reaction_flask = true;
                }
            }
            if (!stack.m_150930_((Item)Registration.VOLT_CELL_ITEM.get())) continue;
            if (has_volt_cell) {
                has_duplicate_items = true;
                continue;
            }
            has_volt_cell = true;
        }
        return has_reaction_flask && has_volt_cell && !has_duplicate_items;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer input, RegistryAccess pRegistryAccess) {
        ReactionFlaskItem.Contents contents = new ReactionFlaskItem.Contents(Map.of(), false);
        for (ItemStack stack : input.m_280657_()) {
            if (!stack.m_150930_((Item)Registration.REACTION_FLASK_ITEM.get())) continue;
            contents = ReactionFlaskItem.Contents.getFromStack(stack);
        }
        if (contents == null) {
            ReactiveMod.LOGGER.error("Reaction flask crafting failed: flask had null contents");
            return ItemStack.f_41583_;
        }
        ItemStack flask = ((ReactionFlaskItem)((Object)Registration.REACTION_FLASK_ITEM.get())).m_7968_();
        ReactionFlaskItem.Contents new_contents = new ReactionFlaskItem.Contents(contents.powers(), true);
        new_contents.saveToStack(flask);
        return flask;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer input) {
        NonNullList remaining_items = NonNullList.m_122780_((int)input.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remaining_items.size(); ++i) {
            ItemStack stack = input.m_8020_(i);
            if (!stack.m_150930_((Item)Registration.VOLT_CELL_ITEM.get())) continue;
            remaining_items.set(i, (Object)stack.m_41720_().m_7968_());
        }
        return remaining_items;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registration.REACTION_FLASK_MODIFY_RECIPE_SERIALIZER.get();
    }
}

