/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.util;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.util.NBTSerializer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class NBTExtras {
    public static final NBTSerializer<Integer> INT = new NBTSerializer<Integer>(){

        @Override
        public Tag encode(Integer data) {
            return IntTag.m_128679_((int)data);
        }

        @Override
        @Nullable
        public Integer decode(Tag input) {
            if (!(input instanceof IntTag)) {
                return null;
            }
            IntTag i = (IntTag)input;
            return i.m_7047_();
        }
    };

    public static <T, U> ListTag encodeMap(NBTSerializer<T> t_serializer, NBTSerializer<U> u_serializer, Map<T, U> map) {
        ListTag entries = new ListTag();
        for (T key : map.keySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("key", t_serializer.encode(key));
            tag.m_128365_("value", u_serializer.encode(map.get(key)));
            entries.add((Object)tag);
        }
        return entries;
    }

    public static <T, U> Map<T, U> decodeMap(NBTSerializer<T> t_serializer, NBTSerializer<U> u_serializer, ListTag input) {
        HashMap<T, U> map = new HashMap<T, U>();
        for (Tag tag : input) {
            CompoundTag entry;
            if (!(tag instanceof CompoundTag && (entry = (CompoundTag)tag).m_128441_("key") && entry.m_128441_("value"))) {
                ReactiveMod.LOGGER.error("Skipping bad entry: {}", (Object)tag.toString());
                continue;
            }
            map.put(t_serializer.decode(entry.m_128423_("key")), u_serializer.decode(entry.m_128423_("value")));
        }
        return map;
    }
}

