/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy;

import com.mojang.serialization.Codec;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.AlchemyTags;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.util.Color;
import dev.hyperlynx.reactive.util.PrimedWSV;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class Power {
    private final Color color;
    private final ResourceLocation location;
    private final String name;
    private final Item bottle;
    private final Block render_water_block;
    private final PrimedWSV percent_reactivity;
    public boolean invisible = false;
    public MutableComponent name_override;
    public static final Codec<ResourceKey<Power>> RESOURCE_KEY_CODEC = ResourceKey.codec(Powers.POWER_REGISTRY_KEY);
    public static final StreamCodec<ByteBuf, ResourceKey<Power>> RESOURCE_KEY_STREAM_CODEC = ResourceKey.streamCodec(Powers.POWER_REGISTRY_KEY);
    public static final StreamCodec<ByteBuf, Power> STREAM_CODEC;
    public static final Codec<Power> CODEC;

    public Power(String id, int color, Block render_water_block, Item bottle) {
        this.location = ReactiveMod.location(id);
        this.render_water_block = render_water_block;
        this.color = new Color(color);
        this.bottle = bottle;
        this.name = Util.makeDescriptionId((String)"power", (ResourceLocation)this.location);
        this.percent_reactivity = new PrimedWSV(id + "_reactivity", 50, 200);
    }

    public Power(String id, Color color, Block render_water_block, Item bottle) {
        this.location = ReactiveMod.location(id);
        this.render_water_block = render_water_block;
        this.color = color;
        this.bottle = bottle;
        this.name = Util.makeDescriptionId((String)"power", (ResourceLocation)this.location);
        this.percent_reactivity = new PrimedWSV(id + "_reactivity", 50, 200);
    }

    public Power(ResourceLocation location, Color color, Block render_water_block, Item bottle) {
        this.location = location;
        this.color = color;
        this.render_water_block = render_water_block;
        this.bottle = bottle;
        this.name = Util.makeDescriptionId((String)"power", (ResourceLocation)this.location);
        this.percent_reactivity = new PrimedWSV(String.valueOf(location) + "_reactivity", 50, 200);
    }

    public Power(ResourceLocation location, int color, Block render_water_block, Item bottle) {
        this.location = location;
        this.render_water_block = render_water_block;
        this.color = new Color(color);
        this.bottle = bottle;
        this.name = Util.makeDescriptionId((String)"power", (ResourceLocation)this.location);
        this.percent_reactivity = new PrimedWSV(String.valueOf(location) + "_reactivity", 50, 200);
    }

    public static Map<Power, Integer> generateRandomPowerCombo(Level level) {
        HashMap<Power, Integer> powers = new HashMap<Power, Integer>();
        RandomSource random = level.random;
        for (int i = 0; i < random.nextIntBetweenInclusive(1, 3); ++i) {
            Power power = (Power)((Holder.Reference)Powers.POWER_REGISTRY.getRandom(random).orElseThrow()).value();
            while (power.equals(Powers.ASTRAL_POWER.get())) {
                power = (Power)((Holder.Reference)Powers.POWER_REGISTRY.getRandom(random).orElseThrow()).value();
            }
            powers.put(power, random.nextInt(200, 500));
        }
        return powers;
    }

    public TagKey<Item> getSourceTag() {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.location.getNamespace(), (String)(this.location.getPath() + "_sources")));
    }

    public static Power readPower(CompoundTag tag) {
        return Power.readPower(tag, "name");
    }

    public static Power readPower(CompoundTag tag, String power_key) {
        String rl = tag.getString(power_key);
        ResourceLocation location = ResourceLocation.parse((String)rl);
        return (Power)Powers.POWER_REGISTRY.get(location);
    }

    public Color getColor() {
        return this.color;
    }

    public TextColor getTextColor() {
        return TextColor.fromRgb((int)this.color.hex);
    }

    public String getId() {
        return this.location.getPath();
    }

    public String getName() {
        return Objects.requireNonNullElseGet(this.name_override, () -> Component.translatable((String)this.name)).getString();
    }

    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    public Block getWaterRenderBlock() {
        return this.render_water_block;
    }

    public boolean checkReactivity(int power_level, int threshold) {
        float strength = (float)this.percent_reactivity.get() / 100.0f;
        int adjusted_power_level = (int)((float)power_level * strength);
        return adjusted_power_level >= threshold;
    }

    public static List<Power> getSourcePower(ItemStack i) {
        ArrayList<Power> stack_powers = new ArrayList<Power>();
        Powers.POWER_REGISTRY.stream().forEach(power -> {
            if (i.is(power.getSourceTag())) {
                stack_powers.add((Power)power);
            }
        });
        return stack_powers;
    }

    public static int getSourceLevel(ItemStack i) {
        return WorldSpecificValue.get("power_" + i.getItem().getDescriptionId(), i.is(AlchemyTags.highPower) ? 250 : 40, i.is(AlchemyTags.highPower) ? 500 : 90);
    }

    public boolean hasBottle() {
        return this.bottle != null;
    }

    public boolean matchesBottle(ItemStack i) {
        if (this.hasBottle()) {
            return i.is(this.bottle);
        }
        return false;
    }

    public ItemStack getBottle() {
        if (this.hasBottle()) {
            return this.bottle.getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    public String toString() {
        return this.name;
    }

    static {
        CODEC = RESOURCE_KEY_CODEC.xmap(arg_0 -> Powers.POWER_REGISTRY.get(arg_0), power -> (ResourceKey)Powers.POWER_REGISTRY.getResourceKey(power).orElseThrow());
        STREAM_CODEC = RESOURCE_KEY_STREAM_CODEC.map(arg_0 -> Powers.POWER_REGISTRY.get(arg_0), power -> (ResourceKey)Powers.POWER_REGISTRY.getResourceKey(power).orElseThrow());
    }
}

