/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface PowerBearer {
    default public boolean addPower(Power p, int amount) {
        int prev;
        int amount_to_add = amount;
        if (p == null) {
            return false;
        }
        if (this.getPowerLevel(p) == this.maxPower()) {
            return false;
        }
        if (this.getTotalPowerLevel() + amount_to_add > this.maxPower()) {
            int excess = this.getTotalPowerLevel() + amount_to_add - this.maxPower();
            this.expendAnyPowerExcept(p, excess);
            excess = this.getTotalPowerLevel() + amount_to_add - this.maxPower();
            if (excess > 0) {
                amount_to_add -= excess;
            }
        }
        if ((prev = this.getPowerMap().getOrDefault(p, 0).intValue()) > 0) {
            this.getPowerMap().replace(p, amount_to_add + prev);
        } else {
            this.getPowerMap().put(p, amount_to_add);
        }
        return true;
    }

    default public int getPowerLevel(Power t) {
        if (this.getPowerMap().isEmpty() || this.getPowerMap().get(t) == null) {
            return 0;
        }
        return this.getPowerMap().get(t);
    }

    default public int getTotalPowerLevel() {
        int totalpp = 0;
        for (Power p : this.getPowerMap().keySet()) {
            totalpp += this.getPowerMap().get(p).intValue();
        }
        return totalpp;
    }

    default public boolean expendPower(Power t, int amount) {
        if (this.getPowerMap().isEmpty() || !this.getPowerMap().containsKey(t)) {
            return false;
        }
        int level = this.getPowerMap().get(t);
        if (level > amount) {
            this.getPowerMap().put(t, level - amount);
            return true;
        }
        if (level == amount) {
            this.getPowerMap().put(t, 0);
            return true;
        }
        this.getPowerMap().put(t, 0);
        return false;
    }

    default public void expendAnyPowerExcept(Power immune_power, int amount) {
        boolean expended = false;
        for (Power p : this.getPowerMap().keySet()) {
            if (p != immune_power && p != Powers.CURSE_POWER.get()) {
                expended = this.expendPower(p, amount);
            }
            if (!expended) continue;
            return;
        }
    }

    default public void expendPower() {
        this.getPowerMap().clear();
    }

    public int maxPower();

    @NotNull
    public Map<Power, Integer> getPowerMap();

    default public int getPowerCount() {
        return this.getPowerMap().size();
    }
}

