/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PowerBuilder {
    public final ResourceLocation id;
    public transient int color;
    public transient Holder<Item> bottle_holder;
    public transient Holder<Block> water_holder;
    public transient Item bottle;
    public transient Block water;
    public transient boolean invisible = false;
    public transient MutableComponent custom_component = null;

    public PowerBuilder(ResourceLocation id) {
        this.id = id;
        this.color = 0xFFFFFF;
        this.water = Blocks.WATER;
    }

    public PowerBuilder color(int color) {
        this.color = color;
        return this;
    }

    public PowerBuilder bottle(Holder<Item> bottle) {
        this.bottle_holder = bottle;
        return this;
    }

    public PowerBuilder bottle(Item bottle) {
        this.bottle = bottle;
        return this;
    }

    public PowerBuilder water(Holder<Block> water) {
        this.water_holder = water;
        return this;
    }

    public PowerBuilder water(Block water) {
        this.water = water;
        return this;
    }

    public PowerBuilder setName(MutableComponent name) {
        this.custom_component = name;
        return this;
    }

    public Power build() {
        if (this.bottle_holder != null) {
            this.bottle = (Item)this.bottle_holder.value();
        }
        if (this.water_holder != null) {
            this.water = (Block)this.water_holder.value();
        }
        if (this.bottle != null && this.bottle.getDefaultInstance().isEmpty()) {
            ReactiveMod.LOGGER.error("Power {} has an invalid bottle item!", (Object)this.id);
        }
        if (this.water != null && this.water.defaultBlockState().is(Blocks.AIR)) {
            throw new InvalidPowerBuilderParameterException("Power " + String.valueOf(this.id) + " has an invalid water block!");
        }
        Power power = new Power(this.id, this.color, this.water, this.bottle);
        power.invisible = this.invisible;
        power.name_override = this.custom_component;
        return power;
    }

    public static class InvalidPowerBuilderParameterException
    extends RuntimeException {
        public InvalidPowerBuilderParameterException(String msg) {
            super(msg);
        }
    }
}

