/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.material.MaterialData;
import dev.hyperlynx.reactive.be.MaterialBlockEntity;
import dev.hyperlynx.reactive.blocks.MaterialBlock;
import dev.hyperlynx.reactive.net.MaterialDataSyncRequestPayload;
import dev.hyperlynx.reactive.net.MaterialRenamePayload;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(modid="reactive", value={Dist.CLIENT})
public class ClientMaterialMan {
    public static final AtomicReference<MaterialData> clientside_data = new AtomicReference<MaterialData>(MaterialData.empty());
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final Semaphore response_ready = new Semaphore(0, false);
    private static final AtomicBoolean query_active = new AtomicBoolean(false);

    public static MaterialData data() {
        if (initialized.get()) {
            return clientside_data.get();
        }
        if (query_active.get()) {
            ReactiveMod.LOGGER.warn("Multiple threads are requesting material definitions at one time");
        }
        ReactiveMod.LOGGER.debug("Requesting material definitions from server");
        try {
            query_active.set(true);
            PacketDistributor.sendToServer((CustomPacketPayload)new MaterialDataSyncRequestPayload(-1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            boolean got_result = response_ready.tryAcquire(1, 1L, TimeUnit.SECONDS);
            if (got_result) {
                ReactiveMod.LOGGER.debug("Received material definitions from server");
                return clientside_data.get();
            }
            ReactiveMod.LOGGER.error("Timeout while fetching material definitions from the server. Custom materials will not work properly!");
            return MaterialData.empty();
        }
        catch (NullPointerException exception) {
            ReactiveMod.LOGGER.debug("Connection wasn't available, this request failed");
            return MaterialData.empty();
        }
        catch (InterruptedException exception) {
            ReactiveMod.LOGGER.fatal("Client material fetch was interrupted by an outside force. Data will not sync.");
            return MaterialData.empty();
        }
    }

    public static void receiveDataAsync(MaterialData data) {
        clientside_data.set(data);
        initialized.set(true);
        query_active.set(false);
        response_ready.release();
    }

    @SubscribeEvent
    public static void worldLoad(LevelEvent.Load event) {
        if (event.getLevel().isClientSide()) {
            initialized.set(false);
            clientside_data.set(MaterialData.empty());
        }
    }

    public static Component getName(ResourceLocation id) {
        if (ClientMaterialMan.clientside_data.get().materials.containsKey(id)) {
            return clientside_data.get().get(id).getNameComponent();
        }
        return Component.translatable((String)"block.reactive.invalid_material");
    }

    public static void rename(ResourceLocation material_id, String value) {
        PacketDistributor.sendToServer((CustomPacketPayload)new MaterialRenamePayload(material_id, value), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static List<ResourceLocation> getKeysInDiscoveryOrder() {
        return ClientMaterialMan.data().materials.keySet().stream().sorted((left_id, right_id) -> Math.clamp(ClientMaterialMan.data().materials.get(right_id).getDiscoveryTime() - ClientMaterialMan.data().materials.get(left_id).getDiscoveryTime(), -2147483647, Integer.MAX_VALUE)).toList();
    }

    public static void handleMaterialBESync(IPayloadContext context, ResourceLocation material_id, BlockPos pos) {
        BlockEntity blockEntity;
        Level level = context.player().level();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clevel = (ClientLevel)level;
        if (!(clevel.getBlockState(pos).getBlock() instanceof MaterialBlock)) {
            clevel.setBlock(pos, ((MaterialBlock)((Object)ReactiveBlocks.MATERIAL_BLOCK.get())).defaultBlockState(), 4);
        }
        if ((blockEntity = clevel.getBlockEntity(pos)) instanceof MaterialBlockEntity) {
            MaterialBlockEntity mbe = (MaterialBlockEntity)blockEntity;
            mbe.setMaterial((Level)clevel, material_id);
        }
    }
}

