/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.material.BuiltInMaterials;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.net.MaterialDataSyncPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.network.PacketDistributor;

public class MaterialData
extends SavedData {
    protected final Map<ResourceLocation, Material> materials;
    private final List<ResourceLocation> datapack_material_ids;
    public static final int CURRENT_VERSION = 1;
    public static final StreamCodec<RegistryFriendlyByteBuf, MaterialData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, Material.STREAM_CODEC), MaterialData::materials, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), MaterialData::datapack_material_ids, MaterialData::new);
    private static final Codec<MaterialData> CODEC_V1 = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, Material.CODEC).fieldOf("materials").forGetter(MaterialData::materials), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("datapack_material_ids").orElse(List.of()).forGetter(MaterialData::datapack_material_ids)).apply((Applicative)instance, MaterialData::new));
    public static final Map<Integer, Codec<MaterialData>> CODECS_BY_VERSION = Map.of(1, CODEC_V1);

    public MaterialData(Map<ResourceLocation, Material> materials, List<ResourceLocation> datapack_material_ids) {
        this.materials = new HashMap<ResourceLocation, Material>(materials);
        this.datapack_material_ids = new ArrayList<ResourceLocation>(datapack_material_ids);
    }

    public MaterialData(MaterialData data) {
        this.materials = new HashMap<ResourceLocation, Material>(data.materials);
        this.datapack_material_ids = new ArrayList<ResourceLocation>(data.datapack_material_ids);
    }

    public MaterialData addBuiltIns(ServerLevel level) {
        Optional optional_registry = level.registryAccess().registry(BuiltInMaterials.KEY);
        if (optional_registry.isEmpty()) {
            ReactiveMod.LOGGER.error("No built in material registry was defined, so none will be loaded.");
            return this;
        }
        ReactiveMod.LOGGER.info("Removing existing datapack materials");
        for (ResourceLocation existing_builtin_id : this.datapack_material_ids) {
            Material stub = Material.empty();
            stub.setName(Component.translatable((String)"text.reactive.datapack_material_removed").getString());
            this.materials.put(existing_builtin_id, stub);
        }
        this.datapack_material_ids.clear();
        for (Map.Entry material_entry : ((Registry)optional_registry.get()).entrySet()) {
            this.materials.put(((ResourceKey)material_entry.getKey()).location(), (Material)material_entry.getValue());
            this.datapack_material_ids.add(((ResourceKey)material_entry.getKey()).location());
            ReactiveMod.LOGGER.info("Adding datapack material {}", (Object)((ResourceKey)material_entry.getKey()).location());
        }
        return this;
    }

    public static MaterialData empty() {
        return new MaterialData(new HashMap<ResourceLocation, Material>(), new ArrayList<ResourceLocation>());
    }

    private Map<ResourceLocation, Material> materials() {
        return this.materials;
    }

    private List<ResourceLocation> datapack_material_ids() {
        return this.datapack_material_ids;
    }

    public Material get(ResourceLocation id) {
        if (this.materials.containsKey(id)) {
            return this.materials.get(id);
        }
        return Material.empty();
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        DataResult data = CODEC_V1.encode((Object)this, (DynamicOps)NbtOps.INSTANCE, (Object)tag);
        CompoundTag saved_tag = (CompoundTag)data.getOrThrow();
        saved_tag.put("version", (Tag)IntTag.valueOf((int)1));
        return saved_tag;
    }

    public static MaterialData load(CompoundTag tag, HolderLookup.Provider ignoredprovider) {
        Codec<MaterialData> codec;
        DataResult result;
        int version = 0;
        if (tag.contains("version", 3)) {
            version = tag.getInt("version");
        }
        if (version != 1) {
            ReactiveMod.LOGGER.info("Attempting to load material data with mismatched version {} (current is {})", (Object)version, (Object)1);
            if (!CODECS_BY_VERSION.containsKey(version)) {
                ReactiveMod.LOGGER.error("No codec for this version was found, attempting load with most recent codec.");
            }
        }
        if ((result = (codec = CODECS_BY_VERSION.getOrDefault(version, CODEC_V1)).decode((DynamicOps)NbtOps.INSTANCE, (Object)tag)).isError()) {
            ReactiveMod.LOGGER.fatal("Failed to load material data. Materials will be lost!");
            return null;
        }
        return (MaterialData)((Object)((Pair)result.getOrThrow()).getFirst());
    }

    public void addMaterial(ResourceLocation id, Material material) {
        this.materials.put(id, material);
        this.setDirty();
    }

    public void setToEmpty(ResourceLocation id) {
        Material stub = Material.empty();
        stub.setName(Component.translatable((String)"text.reactive.material_removed").getString());
        this.materials.put(id, stub);
        this.setDirty();
    }

    public void reset() {
        this.materials.clear();
        this.setDirty();
    }

    public void setDirty() {
        super.setDirty();
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new MaterialDataSyncPayload(new MaterialData(this)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public int datapackIdCount() {
        return this.datapack_material_ids.size();
    }
}

