/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ReactiveMod;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.SoundType;

public enum MaterialModel implements StringRepresentable
{
    SALT("salt", 0.0f, SoundType.SAND),
    CRACKED("cracked", 1.0f, SoundType.DRIPSTONE_BLOCK),
    GEL("gel", 2.0f, SoundType.SLIME_BLOCK),
    STREAKED("streaked", 3.0f, SoundType.DEEPSLATE),
    SMOOTH("smooth", 4.0f, SoundType.WOOL),
    CIRCLES("circles", 5.0f, SoundType.DRIPSTONE_BLOCK),
    SQUARES("squares", 6.0f, SoundType.CALCITE),
    STATIC("static", 7.0f, SoundType.CHAIN),
    WOOL("wool", 8.0f, SoundType.WOOL);

    private final String name;
    private final float index;
    private final SoundType sound_type;

    private MaterialModel(String name, float index, SoundType sound_type) {
        this.name = name;
        this.index = index;
        this.sound_type = sound_type;
    }

    public String getSerializedName() {
        return this.name;
    }

    public float getModelIndex() {
        return this.index;
    }

    public SoundType getSoundType() {
        return this.sound_type;
    }

    public static MaterialModel fromName(String name) {
        try {
            return MaterialModel.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ReactiveMod.LOGGER.error("Invalid material model name {} was used. This should never happen...", (Object)name);
            return SALT;
        }
    }

    public static boolean isNameValid(String name) {
        try {
            MaterialModel.valueOf(name.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

