/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import com.mojang.serialization.Codec;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.StringFormulaOutcome;
import dev.hyperlynx.reactive.registration.ReactiveDataMaps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;

public class StringMaterialProperty
extends MaterialProperty<String> {
    @Override
    public String instance(Map<Power, Integer> formula) {
        ResourceLocation id = MaterialProperties.PROPERTY_REGISTRY.getKey((Object)this);
        assert (id != null);
        Optional holder = MaterialProperties.PROPERTY_REGISTRY.getHolder(id);
        if (holder.isEmpty()) {
            throw new RuntimeException("Can't retrieve the material property registry from location " + String.valueOf(id));
        }
        List outcomes = (List)((Holder.Reference)holder.get()).getData(ReactiveDataMaps.FORMULA_OUTCOME_MAP);
        if (outcomes == null || outcomes.isEmpty()) {
            ReactiveMod.LOGGER.error("No outcome map has been defined for {}, defaulting to empty string", (Object)id);
            return "";
        }
        for (FormulaOutcome outcome : outcomes) {
            if (!(outcome instanceof StringFormulaOutcome)) {
                ReactiveMod.LOGGER.error("Outcome map for {} has a non-applicable outcome type set, skipping.", (Object)id);
                continue;
            }
            StringFormulaOutcome string_outcome = (StringFormulaOutcome)((Object)outcome);
            String result = string_outcome.calculate(formula);
            if (result.isEmpty()) continue;
            return result;
        }
        return "";
    }

    @Override
    public Codec<String> codec() {
        return Codec.STRING;
    }
}

