/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material.formula;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.material.formula.FloatFormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcomeTypes;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class FloatZeroToMaxFormulaOutcome
extends FormulaOutcome
implements FloatFormulaOutcome {
    final ResourceLocation power;
    final int min_power;
    final int max_power;
    final float max_value;
    public static final MapCodec<FloatZeroToMaxFormulaOutcome> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("power").forGetter(FloatZeroToMaxFormulaOutcome::power), (App)Codec.INT.fieldOf("min_power").forGetter(FloatZeroToMaxFormulaOutcome::getMinPower), (App)Codec.INT.fieldOf("max_power").forGetter(FloatZeroToMaxFormulaOutcome::getMaxPower), (App)Codec.FLOAT.fieldOf("max_value").forGetter(FloatZeroToMaxFormulaOutcome::getMaxValue)).apply((Applicative)instance, FloatZeroToMaxFormulaOutcome::new));

    public FloatZeroToMaxFormulaOutcome(ResourceLocation power, int threshold, int max_power, float max_value) {
        this.power = power;
        this.min_power = threshold;
        this.max_power = max_power;
        this.max_value = max_value;
    }

    public int getMinPower() {
        return this.min_power;
    }

    public int getMaxPower() {
        return this.max_power;
    }

    public float getMaxValue() {
        return this.max_value;
    }

    @Override
    public ResourceLocation power() {
        return this.power;
    }

    @Override
    public MapCodec<? extends FormulaOutcome> type() {
        return (MapCodec)FormulaOutcomeTypes.ZERO_TO_MAX_FLOAT.get();
    }

    @Override
    public float calculate(Map<Power, Integer> formula) {
        Power power = (Power)Powers.POWER_REGISTRY.get(this.power());
        if (formula.containsKey(power) && formula.get(power) > this.getMinPower()) {
            int provided_power = Math.min(formula.get(power) - this.getMinPower(), this.getMaxPower());
            float power_proportion = (float)provided_power / (float)this.getMaxPower();
            return power_proportion * this.getMaxValue();
        }
        return 0.0f;
    }
}

