/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material.formula;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcomeTypes;
import dev.hyperlynx.reactive.alchemy.material.formula.StringFormulaOutcome;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class RangeStringFormulaOutcome
extends FormulaOutcome
implements StringFormulaOutcome {
    final String option;
    final ResourceLocation power_id;
    final int threshold;
    final Optional<Integer> max_power;
    public static final MapCodec<RangeStringFormulaOutcome> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("option").forGetter(RangeStringFormulaOutcome::option), (App)ResourceLocation.CODEC.fieldOf("power").forGetter(RangeStringFormulaOutcome::power), (App)Codec.INT.fieldOf("threshold").forGetter(RangeStringFormulaOutcome::threshold), (App)Codec.INT.optionalFieldOf("max_power").forGetter(RangeStringFormulaOutcome::max_power)).apply((Applicative)instance, RangeStringFormulaOutcome::new));

    public RangeStringFormulaOutcome(String option, ResourceLocation power_id, int threshold, Optional<Integer> max_power) {
        this.power_id = power_id;
        this.option = option;
        this.threshold = threshold;
        this.max_power = max_power;
    }

    private String option() {
        return this.option;
    }

    @Override
    public ResourceLocation power() {
        return this.power_id;
    }

    private int threshold() {
        return this.threshold;
    }

    private Optional<Integer> max_power() {
        return this.max_power;
    }

    @Override
    public MapCodec<? extends FormulaOutcome> type() {
        return (MapCodec)FormulaOutcomeTypes.STRING_OPTIONS.get();
    }

    @Override
    public String calculate(Map<Power, Integer> formula) {
        Power power = (Power)Powers.POWER_REGISTRY.get(this.power_id);
        if (power == null) {
            ReactiveMod.LOGGER.error("Invalid power {} in StringFormulaOutcome", (Object)this.power_id);
            return "";
        }
        if (formula.containsKey(power) && formula.get(power) >= this.threshold) {
            if (this.max_power.isPresent() && formula.get(power) > this.max_power.get()) {
                return "";
            }
            return this.option;
        }
        return "";
    }
}

