/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.alchemy.rxn.SynthesisReaction;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import dev.hyperlynx.reactive.registration.ReactiveSoundEvents;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class AstralSynthesisReaction
extends SynthesisReaction {
    public AstralSynthesisReaction(String alias, Power resultPower, Power ... reagents) {
        super(alias, resultPower, reagents);
        this.reagents.replaceAll((p, v) -> 1);
    }

    @Override
    public void run(Reactor reactor) {
        super.run(reactor);
        reactor.addPower((Power)Powers.ASTRAL_POWER.get(), reactor.maxPower());
        Objects.requireNonNull(reactor.getLevel()).playSound(null, reactor.getBlockPos(), SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 0.5f, 1.2f);
        ParticleScribe.drawParticleSphere(Objects.requireNonNull(reactor.getLevel()), (ParticleOptions)ReactiveParticles.STARDUST, reactor.getBlockPos(), 0.5, 1.0, 20);
        Objects.requireNonNull(reactor.getLevel()).playSound(null, reactor.getBlockPos(), (SoundEvent)ReactiveSoundEvents.RUMBLE.get(), SoundSource.BLOCKS);
        if (reactor instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)reactor;
            crucible.integrity = 12;
        }
    }
}

