/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class OmenConversionReaction
extends Reaction {
    public OmenConversionReaction(String alias) {
        super(alias, (Power)Powers.BLAZE_POWER.get());
        this.reagents.put((Power)Powers.OMEN_POWER.get(), WorldSpecificValue.get("omen_balance_for_conversion", 100, 150));
    }

    @Override
    public void run(Reactor reactor) {
        super.run(reactor);
        reactor.expendPower((Power)Powers.BLAZE_POWER.get(), WorldSpecificValue.get("omen_conversion_cost", 20, 40));
        int omen = reactor.getPowerLevel((Power)Powers.OMEN_POWER.get());
        reactor.expendPower((Power)Powers.OMEN_POWER.get(), omen);
        reactor.addPower((Power)Powers.SOUL_POWER.get(), omen / 2);
        Level level = Objects.requireNonNull(reactor.getLevel());
        level.playSound(null, reactor.getBlockPos(), SoundEvents.TRIAL_SPAWNER_OMINOUS_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.1f);
        ParticleScribe.drawParticleSphere(level, (ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, reactor.getBlockPos(), 0.7, 0.5, 10);
        reactor.setDirty();
    }
}

