/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class DisplacedBlockEntity
extends BlockEntity {
    private BlockState self_state;
    public BlockPos chain_target;
    public int depth = 0;
    public boolean first_tick = true;
    private CompoundTag unresolved_self_state;
    public static final String BLOCK_STATE_TAG = "DisplacedBlockState";
    public static final String CHAIN_TARGET_TAG = "ChainTargetBlockPos";
    public static final String DEPTH_TAG = "ChainDepth";

    public DisplacedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ReactiveBlockEntityTypes.DISPLACED_BLOCK.get(), pos, state);
    }

    protected void saveAdditional(@NotNull CompoundTag main_tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(main_tag, registries);
        if (this.getSelfState() == null) {
            main_tag.put(BLOCK_STATE_TAG, (Tag)this.unresolved_self_state);
        } else {
            main_tag.put(BLOCK_STATE_TAG, (Tag)NbtUtils.writeBlockState((BlockState)this.getSelfState()));
        }
        if (this.chain_target != null) {
            main_tag.put(CHAIN_TARGET_TAG, NbtUtils.writeBlockPos((BlockPos)this.chain_target));
        }
        main_tag.put(DEPTH_TAG, (Tag)IntTag.valueOf((int)this.depth));
    }

    public void loadAdditional(@NotNull CompoundTag main_tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(main_tag, registries);
        this.unresolved_self_state = main_tag.getCompound(BLOCK_STATE_TAG);
        if (main_tag.contains(CHAIN_TARGET_TAG)) {
            this.chain_target = NbtUtils.readBlockPos((CompoundTag)main_tag, (String)CHAIN_TARGET_TAG).orElse(BlockPos.ZERO);
        }
        if (main_tag.contains(DEPTH_TAG)) {
            this.depth = main_tag.getInt(DEPTH_TAG);
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
    }

    public BlockState getSelfState() {
        if (this.self_state == null) {
            if (this.getLevel() == null) {
                return null;
            }
            if (this.getLevel().isClientSide && this.unresolved_self_state == null) {
                return Blocks.AIR.defaultBlockState();
            }
            try {
                this.setSelfState(NbtUtils.readBlockState((HolderGetter)this.getLevel().holderLookup(Registries.BLOCK), (CompoundTag)this.unresolved_self_state));
            }
            catch (NullPointerException exception) {
                ReactiveMod.LOGGER.error("Displaced block entity at {} had no internal state, so it will now contain air.", (Object)this.getBlockPos());
                this.setSelfState(Blocks.AIR.defaultBlockState());
            }
        }
        return this.self_state;
    }

    public void setSelfState(BlockState self_state) {
        this.self_state = self_state;
    }
}

