/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.blocks.GravityChandelierBlock;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveMobEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GravityChandelierBlockEntity
extends BlockEntity {
    public static final double RANGE = 10.0;

    public GravityChandelierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ReactiveBlockEntityTypes.GRAVITY_CHANDELIER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos) {
        if (!level.getBlockState(pos).is((Block)ReactiveBlocks.GRAVITY_CHANDELIER.get())) {
            return;
        }
        BlockPos effect_center = (Boolean)level.getBlockState(pos).getValue((Property)GravityChandelierBlock.OFFSET) != false ? pos.above(10) : pos;
        List targets = level.getEntitiesOfClass(Entity.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)effect_center), (double)20.0, (double)20.0, (double)20.0), ent -> ent.getPosition(0.0f).distanceToSqr(Vec3.atCenterOf((Vec3i)effect_center)) < 100.0);
        for (Entity target : targets) {
            if (target instanceof ItemEntity) {
                target.setNoGravity(true);
                continue;
            }
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity victim = (LivingEntity)target;
            victim.addEffect(new MobEffectInstance(ReactiveMobEffects.NULL_GRAVITY, 10));
            victim.resetFallDistance();
        }
    }
}

