/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MaterialBlockEntity
extends BlockEntity {
    ResourceLocation material_id;
    public int generic_delay = 0;

    public MaterialBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ReactiveBlockEntityTypes.MATERIAL.get(), pos, blockState);
    }

    public Material getMaterial() {
        if (this.material_id == null) {
            return Material.empty();
        }
        return MaterialMan.fetch(this.level, this.material_id);
    }

    public void setMaterial(Level level, ResourceLocation material_id) {
        if (MaterialMan.occupied(level, material_id)) {
            this.material_id = material_id;
        } else {
            ReactiveMod.LOGGER.error("Material block tried to take an invalid id {}, which is not yet occupied.", (Object)material_id);
        }
    }

    public boolean hasNoValidMaterial() {
        return this.material_id == null;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.material_id = ResourceLocation.tryParse((String)tag.getString("material_id"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.material_id == null) {
            return;
        }
        tag.put("material_id", (Tag)StringTag.valueOf((String)this.material_id.toString()));
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
    }

    public ResourceLocation getMaterialId() {
        return this.material_id;
    }
}

