/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.blocks.MnemonicBlock;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class MnemonicBlockEntity
extends BlockEntity {
    List<OutputStep> memory = new ArrayList<OutputStep>();
    int index = 0;
    int counter = 0;
    Status status = Status.EMPTY;
    public static final int MAX_SIGNAL_DURATION = 600;
    public static final int MAX_SEQUENCE_LENGTH = 256;
    public static final String MEMORY_TAG = "Memory";
    public static final String INDEX_TAG = "RecordingIndex";
    public static final String COUNTER_TAG = "PlaybackCounter";
    public static final String STATUS_TAG = "Status";

    public MnemonicBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ReactiveBlockEntityTypes.MNEMONIC_BULB.value(), pPos, pBlockState);
    }

    public void performTick(Level level, BlockPos pos, BlockState state) {
        int input = level.getDirectSignalTo(pos);
        switch (this.status.ordinal()) {
            case 0: {
                if (input == 0) {
                    return;
                }
                this.index = 0;
                level.setBlock(pos, (BlockState)state.setValue((Property)MnemonicBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                this.status = Status.RECORDING;
                break;
            }
            case 1: {
                if (!this.memory.isEmpty() && this.memory.getLast().signal == input) {
                    this.memory.getLast().increment();
                } else {
                    if (this.memory.size() >= 256) {
                        this.memory.removeFirst();
                    }
                    this.memory.add(new OutputStep(input));
                }
                if (((Boolean)state.getValue((Property)MnemonicBlock.CHARGED)).booleanValue()) {
                    this.index = 0;
                    level.setBlock(pos, (BlockState)state.setValue((Property)MnemonicBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                    this.status = Status.REPLAYING;
                }
                if (this.memory.getLast().duration <= 600) break;
                if (input == 0) {
                    this.status = Status.DISABLED;
                    level.setBlock(pos, (BlockState)state.setValue((Property)MnemonicBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                    break;
                }
                this.memory.add(new OutputStep(input));
                break;
            }
            case 3: {
                if (((Boolean)state.getValue((Property)MnemonicBlock.CHARGED)).booleanValue()) {
                    this.index = 0;
                    this.status = Status.REPLAYING;
                    break;
                }
                if (input <= 0) break;
                this.memory.clear();
                this.status = Status.EMPTY;
                break;
            }
            case 2: {
                if (!((Boolean)state.getValue((Property)MnemonicBlock.CHARGED)).booleanValue()) {
                    level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)MnemonicBlock.POWER, (Comparable)Integer.valueOf(0))).setValue((Property)MnemonicBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                    this.status = Status.DISABLED;
                }
                this.index %= this.memory.size();
                OutputStep output = this.memory.get(this.index);
                if (this.counter < 1) {
                    level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)MnemonicBlock.POWER, (Comparable)Integer.valueOf(output.signal))).setValue((Property)MnemonicBlock.ACTIVE, (Comparable)Boolean.valueOf(output.signal > 0)), 3);
                    level.playSound(null, pos, output.signal > 0 ? SoundEvents.COPPER_BULB_TURN_ON : SoundEvents.COPPER_BULB_TURN_OFF, SoundSource.BLOCKS, 1.3f, 0.5f + (float)(output.signal + 1) / 54.0f);
                    level.playSound(null, pos, SoundEvents.MUD_HIT, SoundSource.BLOCKS, 0.1f, 0.7f + (float)(output.signal + 1) / 54.0f);
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
                    this.counter = output.duration;
                    ++this.index;
                }
                --this.counter;
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MnemonicBlockEntity bulb) {
        bulb.performTick(level, pos, state);
    }

    public boolean hasMemory() {
        return !this.memory.isEmpty();
    }

    public void stopRecording() {
        if (this.status.equals((Object)Status.RECORDING)) {
            this.status = Status.DISABLED;
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ListTag memory_list = new ListTag();
        memory_list.addAll(this.memory.stream().map(OutputStep::save).toList());
        tag.put(MEMORY_TAG, (Tag)memory_list);
        tag.put(INDEX_TAG, (Tag)IntTag.valueOf((int)this.index));
        tag.put(COUNTER_TAG, (Tag)IntTag.valueOf((int)this.counter));
        tag.put(STATUS_TAG, (Tag)StringTag.valueOf((String)this.status.name()));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ListTag memory_list = tag.getList(MEMORY_TAG, 10);
        this.memory = new ArrayList<OutputStep>(memory_list.stream().map(OutputStep::load).toList());
        this.index = tag.getInt(INDEX_TAG);
        this.counter = tag.getInt(COUNTER_TAG);
        this.status = Status.valueOf(tag.getString(STATUS_TAG));
    }

    static enum Status {
        EMPTY,
        RECORDING,
        REPLAYING,
        DISABLED;

    }

    static class OutputStep {
        public final int signal;
        public int duration;

        public OutputStep(int signal) {
            this.signal = signal;
            this.duration = 1;
        }

        public static OutputStep load(Tag tag) {
            if (!(tag instanceof CompoundTag)) {
                System.err.println("The mnemonic tag was not a compound tag! Oh no!");
                return null;
            }
            CompoundTag compound = (CompoundTag)tag;
            OutputStep ret = new OutputStep(compound.getInt("signal"));
            ret.duration = compound.getInt("duration");
            return ret;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.put("signal", (Tag)IntTag.valueOf((int)this.signal));
            tag.put("duration", (Tag)IntTag.valueOf((int)this.duration));
            return tag;
        }

        public void increment() {
            ++this.duration;
        }
    }
}

