/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import dev.hyperlynx.reactive.util.BeamHelper;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class SymbolBlockEntity
extends BlockEntity {
    public Item symbol_item = Items.BARRIER;

    public SymbolBlockEntity(BlockPos pos, BlockState state, Item item) {
        super((BlockEntityType)ReactiveBlockEntityTypes.SYMBOL.get(), pos, state);
        NeoForge.EVENT_BUS.register((Object)this);
        this.setItem(item);
    }

    public SymbolBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ReactiveBlockEntityTypes.SYMBOL.get(), pos, state);
    }

    public void setItem(Item item) {
        this.symbol_item = item;
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntity().level().isClientSide || !this.symbol_item.getDefaultInstance().is((Item)ReactiveItems.OCCULT_SYMBOL.get()) || !(event.getEntity() instanceof Player)) {
            return;
        }
        double dist = BeamHelper.distance(event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ());
        if (dist > (double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue()) {
            return;
        }
        Level level = event.getEntity().level();
        if (level.getBlockState(this.getBlockPos()).isAir()) {
            return;
        }
        level.setBlock(this.getBlockPos(), Blocks.AIR.defaultBlockState(), 2);
        level.playSound(null, this.getBlockPos(), SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 0.7f, 0.9f + level.random.nextFloat() * 0.1f);
        if (WorldSpecificValue.getBool("occult_death_spawn_zombie", 0.5f)) {
            Zombie zombie = new Zombie(level);
            zombie.setPos(event.getEntity().getPosition(0.0f));
            zombie.setCustomName(event.getEntity().getDisplayName());
            zombie.setCustomNameVisible(true);
            level.addFreshEntity((Entity)zombie);
        } else {
            Skeleton skeleton = new Skeleton(EntityType.SKELETON, level);
            skeleton.setPos(event.getEntity().getPosition(0.0f));
            skeleton.setCustomName(event.getEntity().getDisplayName());
            skeleton.setCustomNameVisible(true);
            level.addFreshEntity((Entity)skeleton);
        }
        for (int i = 0; i < 4; ++i) {
            ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ReactiveParticles.SMALL_BLACK_RUNE, this.getBlockPos(), event.getEntity().blockPosition().above(), 5, 4, 0.7);
        }
    }
}

