/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.alchemy.AlchemyTags;
import dev.hyperlynx.reactive.items.AcidBucketItem;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AcidBlock
extends Block
implements BucketPickup {
    public AcidBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @NotNull
    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor accessor, @NotNull BlockPos pos, @NotNull BlockState state) {
        accessor.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        return ((AcidBucketItem)((Object)ReactiveItems.ACID_BUCKET.get())).getDefaultInstance();
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.SLIME_BLOCK_BREAK);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState p_154285_, @NotNull BlockGetter p_154286_, @NotNull BlockPos p_154287_, @NotNull CollisionContext p_154288_) {
        return Shapes.empty();
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            ItemStack stack = item.getItem();
            if (stack.getMaxStackSize() > 1) {
                stack.shrink(1);
            } else {
                stack.hurtAndBreak(3, (ServerLevel)level, null, i -> stack.setCount(0));
            }
            if (stack.getCount() < 1) {
                item.kill();
                level.playSound(null, pos, SoundEvents.GENERIC_BURN, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                item.setItem(stack);
            }
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        living.makeStuckInBlock(state, new Vec3((double)0.9f, 1.5, (double)0.9f));
        living.hurt(level.damageSources().inFire(), 2.0f);
    }

    private void killPlantsUnderneath(Level level, BlockPos pos, BlockState state) {
        if (this.blockIsOnExcludedList(level.getBlockState(pos.below()))) {
            return;
        }
        level.scheduleTick(pos, state.getBlock(), 10);
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rng) {
        if (!((Boolean)ConfigMan.COMMON.acidMeltBlockEntities.get()).booleanValue() && level.getBlockEntity(pos.below()) != null) {
            return;
        }
        BlockState state_beneath = level.getBlockState(pos.below());
        if (this.blockIsOnExcludedList(state_beneath)) {
            return;
        }
        if (state_beneath.getBlock() instanceof SnowyDirtBlock) {
            level.setBlockAndUpdate(pos.below(), Blocks.COARSE_DIRT.defaultBlockState());
        }
        if (state_beneath.getBlock() instanceof LeavesBlock || state_beneath.getBlock() instanceof CropBlock || state_beneath.getBlock() instanceof GrowingPlantBlock) {
            level.setBlockAndUpdate(pos.below(), state);
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            level.scheduleTick(pos.below(), state.getBlock(), 10);
        }
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rng) {
        if (!((Boolean)ConfigMan.COMMON.acidMeltBlockEntities.get()).booleanValue() && level.getBlockEntity(pos.below()) != null) {
            return;
        }
        this.killPlantsUnderneath((Level)level, pos, state);
        BlockState state_beneath = level.getBlockState(pos.below());
        if (this.blockIsOnExcludedList(state_beneath)) {
            return;
        }
        ItemStack pick_stack = new ItemStack((ItemLike)state_beneath.getBlock());
        if (pick_stack.is(ItemTags.LOGS) || pick_stack.is(ItemTags.PLANKS) || pick_stack.is(ItemTags.WOOL) || pick_stack.is(ItemTags.WOOL_CARPETS) || state_beneath.getBlock() instanceof MossBlock || state_beneath.is(Blocks.DRIPSTONE_BLOCK)) {
            level.setBlockAndUpdate(pos.below(), state);
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
        if (state_beneath.getBlock() instanceof WeatheringCopper && WeatheringCopper.getNext((Block)state_beneath.getBlock()).isPresent()) {
            level.setBlockAndUpdate(pos.below(), ((Block)WeatheringCopper.getNext((Block)state_beneath.getBlock()).get()).defaultBlockState());
        }
    }

    private boolean blockIsOnExcludedList(BlockState b) {
        return b.is(AlchemyTags.acidImmune);
    }

    public boolean isRandomlyTicking(@NotNull BlockState irrelevant) {
        return true;
    }

    public void onPlace(@NotNull BlockState p_60566_, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState p_60569_, boolean p_60570_) {
        this.killPlantsUnderneath(level, pos, level.getBlockState(pos));
    }

    public void neighborChanged(@NotNull BlockState our_state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighbor_pos, boolean unknown) {
        this.killPlantsUnderneath(level, pos, our_state);
    }

    public void animateTick(@NotNull BlockState state, Level level, BlockPos pos, @NotNull RandomSource rng) {
        if (!level.getBlockState(pos.above()).isSolidRender((BlockGetter)level, pos)) {
            for (int i = 0; i < 1; ++i) {
                double x = (float)pos.getX() + rng.nextFloat();
                double y = (float)pos.getY() + 1.0f;
                double z = (float)pos.getZ() + rng.nextFloat();
                level.addParticle((ParticleOptions)ReactiveParticles.ACID_BUBBLE, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }
}

