/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreezeRodBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0), (VoxelShape)Shapes.join((VoxelShape)Block.box((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), (BooleanOp)BooleanOp.ONLY_FIRST));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public BreezeRodBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            AABB bubble_box = this.getShape(state, (BlockGetter)level, pos, CollisionContext.empty()).bounds().move(pos);
            if (!level.getFluidState(pos.above()).is((Fluid)Fluids.WATER)) {
                bubble_box.setMaxY(0.8);
            }
            ParticleScribe.drawParticleBox(level, (ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, bubble_box, 1);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is((Fluid)Fluids.WATER)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor level_access, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level_access.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level_access));
        }
        return super.updateShape(state, direction, state2, level_access, pos, pos2);
    }
}

