/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.PowerBottleInsertContext;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.special.SpecialCaseMan;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleShapedBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrucibleBlock
extends CrucibleShapedBlock
implements EntityBlock,
WorldlyContainerHolder {
    public static final BooleanProperty FULL = BooleanProperty.create((String)"full");
    protected static final VoxelShape INSIDE = Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);

    public CrucibleBlock(BlockBehaviour.Properties p) {
        super(p);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FULL, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FULL});
        super.createBlockStateDefinition(builder);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CrucibleBlockEntity(pos, state);
    }

    public static List<Entity> getEntitesInside(BlockPos pos, Level level) {
        return level.getEntities(null, INSIDE.bounds().move(pos));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos my_pos, Block block, BlockPos neighbor_pos, boolean unknown_flag) {
        BlockEntity blockEntity;
        int signal = level.getDirectSignalTo(my_pos);
        if (signal > WorldSpecificValue.get("redstone_void_threshold", 11, 14) && (blockEntity = level.getBlockEntity(my_pos)) instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
            switch (WorldSpecificValue.get("redstone_behavior", 0, 2)) {
                case 0: {
                    CrucibleBlockEntity.empty(level, my_pos, state, crucible);
                    crucible.setDirty();
                    break;
                }
                case 1: {
                    if (crucible.getTotalPowerLevel() > 1500) {
                        CrucibleBlockEntity.empty(level, my_pos, state, crucible);
                    } else {
                        crucible.expendAnyPowerExcept((Power)Powers.CURSE_POWER.get(), 1500);
                    }
                    crucible.setDirty();
                    break;
                }
                case 2: {
                    state.setValue((Property)FULL, (Comparable)Boolean.valueOf(false));
                }
            }
            CrucibleBlockEntity.empty(level, my_pos, state, crucible);
            level.playSound(null, my_pos, SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 0.7f, 0.9f + level.random.nextFloat() * 0.1f);
        }
    }

    private boolean checkFluidInStack(IFluidHandlerItem container, Fluid criterion) {
        if (container == null) {
            return false;
        }
        for (int i = 0; i < container.getTanks(); ++i) {
            if (!container.getFluidInTank(i).getFluid().isSame(criterion) || container.getFluidInTank(i).getAmount() < 1000) continue;
            return true;
        }
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide()) {
            if (stack.is((Item)ReactiveItems.ACID_BUCKET.get())) {
                BlockEntity crucible = level.getBlockEntity(pos);
                if (!(crucible instanceof CrucibleBlockEntity)) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                CrucibleBlockEntity c = (CrucibleBlockEntity)crucible;
                c.setStartingColor(((Power)Powers.ACID_POWER.get()).getColor());
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is((Item)ReactiveItems.LITMUS_PAPER.get())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.is(Items.OMINOUS_BOTTLE)) {
            BlockEntity c = level.getBlockEntity(pos);
            if (!(c instanceof CrucibleBlockEntity)) {
                return ItemInteractionResult.FAIL;
            }
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)c;
            CrucibleBlockEntity.insertPowerBottle(crucible, new PowerBottleInsertContext(new UseOnContext(level, player, hand, stack, hit)));
            return ItemInteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)FULL)).booleanValue()) {
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)player.getItemInHand(hand).copy()).orElse(null);
            if (this.checkFluidInStack(fluidHandler, (Fluid)Fluids.WATER)) {
                CrucibleBlock.becomeFull(state, level, pos, (ServerPlayer)player);
                if (((ServerPlayer)player).gameMode.isSurvival()) {
                    fluidHandler.drain(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                    player.setItemInHand(hand, fluidHandler.getContainer());
                }
                return ItemInteractionResult.CONSUME;
            }
            if (this.checkFluidInStack(fluidHandler, (Fluid)Fluids.LAVA)) {
                CrucibleBlock.lavaCrucibleFill(level, pos, (ServerPlayer)player);
                if (((ServerPlayer)player).gameMode.isSurvival()) {
                    fluidHandler.drain(new FluidStack((Fluid)Fluids.LAVA, 1000), IFluidHandler.FluidAction.EXECUTE);
                    player.setItemInHand(hand, fluidHandler.getContainer());
                }
                return ItemInteractionResult.CONSUME;
            }
            if (player.getItemInHand(hand).is((Item)ReactiveItems.ACID_BUCKET.get())) {
                BlockEntity crucible = level.getBlockEntity(pos);
                if (!(crucible instanceof CrucibleBlockEntity)) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                CrucibleBlockEntity c = (CrucibleBlockEntity)crucible;
                CrucibleBlock.becomeFull(state, level, pos, (ServerPlayer)player);
                c.addPower((Power)Powers.ACID_POWER.get(), WorldSpecificValues.BOTTLE_RETURN.get() * 3);
                c.setDirty();
                if (((ServerPlayer)player).gameMode.isSurvival()) {
                    player.setItemInHand(hand, Items.BUCKET.getDefaultInstance());
                }
                return ItemInteractionResult.CONSUME;
            }
        }
        if (((Boolean)state.getValue((Property)FULL)).booleanValue()) {
            if (player.isShiftKeyDown()) {
                level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 0.6f, 0.8f);
                level.setBlock(pos, (BlockState)state.setValue((Property)FULL, (Comparable)Boolean.valueOf(false)), 2);
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity crucible = level.getBlockEntity(pos);
            if (!(crucible instanceof CrucibleBlockEntity)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            CrucibleBlockEntity c = (CrucibleBlockEntity)crucible;
            if (player.getItemInHand(hand).is(Items.GLASS_BOTTLE)) {
                CrucibleBlock.extractGlassBottle(state, level, pos, player, hand, c);
            }
            if (player.getItemInHand(hand).is((Item)ReactiveItems.QUARTZ_BOTTLE.get())) {
                CrucibleBlock.extractQuartzBottle(level, pos, player, hand, c);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static void becomeFull(BlockState state, Level level, BlockPos pos, ServerPlayer player) {
        if (level.dimensionType().ultraWarm()) {
            CrucibleBlock.netherCrucibleFill(level, pos, player);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)FULL, (Comparable)Boolean.valueOf(true)), 2);
            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 0.4f, 1.0f);
        }
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)level.getBlockState(pos)));
    }

    private static void extractQuartzBottle(Level level, BlockPos pos, Player player, InteractionHand hand, CrucibleBlockEntity c) {
        for (Power p : c.getPowerMap().keySet()) {
            if (!p.hasBottle() || c.getPowerLevel(p) <= 600) continue;
            c.expendPower(p, 600);
            player.addItem(SpecialCaseMan.checkBottleSpecialCases(c, p.getBottle()));
            player.getItemInHand(hand).shrink(1);
            level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 0.8f, 1.0f);
            level.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH, pos, GameEvent.Context.of((BlockState)level.getBlockState(pos)));
        }
        c.setDirty();
    }

    private static void extractGlassBottle(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, CrucibleBlockEntity c) {
        int amount = player.getItemInHand(hand).getCount();
        amount = Math.min(amount, 3);
        for (int i = 0; i < amount; ++i) {
            if (c.getTotalPowerLevel() == 0) {
                player.addItem(Items.POTION.getDefaultInstance());
                continue;
            }
            ItemStack potion = c.getPowerLevel((Power)Powers.BODY_POWER.get()) > 10 ? PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.THICK) : (c.getPowerLevel((Power)Powers.ACID_POWER.get()) > 50 ? PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.AWKWARD) : PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.MUNDANE));
            player.addItem(potion);
        }
        player.getItemInHand(hand).shrink(amount);
        level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)level.getBlockState(pos)));
        level.setBlock(pos, (BlockState)state.setValue((Property)FULL, (Comparable)Boolean.valueOf(false)), 2);
    }

    private static void lavaCrucibleFill(Level level, BlockPos pos, ServerPlayer player) {
        level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.0f, Level.ExplosionInteraction.NONE);
        level.playSound(null, pos, SoundEvents.GENERIC_BURN, SoundSource.BLOCKS, 0.5f, 1.0f);
        for (int i = 0; i < 5; ++i) {
            ParticleScribe.drawParticleCrucibleTop(level, (ParticleOptions)ParticleTypes.LARGE_SMOKE, pos);
        }
        ParticleScribe.drawParticleRing(level, (ParticleOptions)ReactiveParticles.RUNE, pos, 0.7, 0.9, 7);
        level.setBlock(pos, Blocks.LAVA_CAULDRON.defaultBlockState(), 2);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)level.getBlockState(pos)));
        ((FlagTrigger)((Object)ReactiveCriterionTriggers.TRY_LAVA_CRUCIBLE.get())).trigger(player);
    }

    private static void netherCrucibleFill(Level level, BlockPos pos, ServerPlayer player) {
        level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
        for (int i = 0; i < 5; ++i) {
            ParticleScribe.drawParticleCrucibleTop(level, (ParticleOptions)ParticleTypes.LARGE_SMOKE, pos);
        }
        ((FlagTrigger)((Object)ReactiveCriterionTriggers.TRY_NETHER_CRUCIBLE.get())).trigger(player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean p_60519_) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
            if (!level.isClientSide) {
                CrucibleBlockEntity.empty(level, pos, state, crucible);
                if (crucible.integrity < 10) {
                    CrucibleBlockEntity.integrityFail(level, pos, state);
                }
            }
        }
        super.onRemove(state, level, pos, new_state, p_60519_);
    }

    public void onRemoveWithoutEmpty(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean p_60519_) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
            if (crucible.linked_crystal != null) {
                crucible.unlinkCrystal(level, pos, state);
            }
        }
        super.onRemove(state, level, pos, new_state, p_60519_);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return (Boolean)state.getValue((Property)FULL);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CrucibleBlockEntity)) {
            return 0;
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
        if (crucible.integrity < 85) {
            return 0;
        }
        if (crucible.used_crystal_this_cycle) {
            return 15;
        }
        int signal = (Boolean)state.getValue((Property)FULL) != false ? 1 : 0;
        signal += crucible.getTotalPowerLevel() / WorldSpecificValue.get("signal_pl_divisor", 133, 400);
        if (crucible.electricCharge > 5) {
            signal += WorldSpecificValue.get("electric_signal_value", 1, 7);
        }
        if (crucible.enderRiftStrength > 1) {
            signal += level.random.nextInt(1, 7);
        }
        return Math.min(signal, 15);
    }

    @Nullable
    public <CrucibleBlockEntity extends BlockEntity> BlockEntityTicker<CrucibleBlockEntity> getTicker(Level level, BlockState state, BlockEntityType<CrucibleBlockEntity> type) {
        if (type == ReactiveBlockEntityTypes.CRUCIBLE.get()) {
            return (l, p, s, c) -> CrucibleBlockEntity.tick(l, p, s, (CrucibleBlockEntity)c);
        }
        return null;
    }

    public WorldlyContainer getContainer(BlockState state, LevelAccessor accessor, BlockPos pos) {
        return new EntityInsideContainer(state, accessor, pos);
    }

    static class EntityInsideContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;

        public EntityInsideContainer(BlockState state, LevelAccessor level, BlockPos pos) {
            super(0);
            this.state = state;
            this.level = level;
            this.pos = pos;
        }

        private List<ItemStack> getEntitySlots() {
            ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
            for (Entity entity : CrucibleBlock.getEntitesInside(this.pos, (Level)this.level)) {
                if (!(entity instanceof ItemEntity)) continue;
                slots.add(((ItemEntity)entity).getItem());
            }
            return slots;
        }

        public int getContainerSize() {
            return this.getEntitySlots().size() + 1;
        }

        public int @NotNull [] getSlotsForFace(Direction face) {
            int size = this.getContainerSize();
            int[] slots_array = new int[size];
            for (int i = 0; i < size; ++i) {
                slots_array[i] = i;
            }
            return slots_array;
        }

        public boolean canPlaceItemThroughFace(int unknown, ItemStack stack, @Nullable Direction face) {
            return (Boolean)this.state.getValue((Property)FULL);
        }

        public boolean canTakeItemThroughFace(int unknown, ItemStack stack, Direction face) {
            return false;
        }

        public ItemStack getItem(int slot) {
            if (slot >= this.getContainerSize() - 1) {
                return ItemStack.EMPTY;
            }
            return this.getEntitySlots().get(slot);
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot == this.getEntitySlots().size()) {
                ItemEntity ingredient_drop = new ItemEntity((Level)this.level, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5265, (double)this.pos.getZ() + 0.5, stack);
                ingredient_drop.setPickUpDelay(50);
                ingredient_drop.setDeltaMovement(0.0, 0.0, 0.0);
                this.level.addFreshEntity((Entity)ingredient_drop);
            } else {
                this.getEntitySlots().set(slot, stack);
            }
        }
    }
}

