/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import com.mojang.serialization.MapCodec;
import dev.hyperlynx.reactive.be.DeskBlockEntity;
import dev.hyperlynx.reactive.menu.DeskMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class DeskBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    protected static final VoxelShape BASE_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)6.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)6.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)4.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)4.0, (double)3.0, (double)2.0, (double)12.0, (double)5.0, (double)14.0), Block.box((double)12.0, (double)3.0, (double)4.0, (double)14.0, (double)5.0, (double)12.0), Block.box((double)2.0, (double)3.0, (double)4.0, (double)4.0, (double)5.0, (double)12.0)});
    protected static final VoxelShape X_BOOK = Shapes.or((VoxelShape)Block.box((double)3.0, (double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)7.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)13.0, (double)9.0, (double)13.0, (double)15.0, (double)14.0), Block.box((double)3.0, (double)13.0, (double)7.0, (double)13.0, (double)14.0, (double)9.0)});
    protected static final VoxelShape Z_BOOK = Shapes.or((VoxelShape)Block.box((double)2.0, (double)13.0, (double)3.0, (double)7.0, (double)15.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)9.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0, (double)13.0), Block.box((double)7.0, (double)13.0, (double)3.0, (double)9.0, (double)14.0, (double)13.0)});
    protected static final VoxelShape X_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape)X_BOOK);
    protected static final VoxelShape Z_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape)Z_BOOK);
    public static final MapCodec<DeskBlock> CODEC = DeskBlock.simpleCodec(DeskBlock::new);

    public DeskBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Direction)state.getValue((Property)FACING)).getAxis().equals((Object)Direction.Axis.X)) {
            return X_SHAPE;
        }
        return Z_SHAPE;
    }

    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (handler != null) {
            return new SimpleMenuProvider((container_id, player_inventory, player) -> new DeskMenu(container_id, player_inventory, handler, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), (Component)Component.translatable((String)"menu.title.reactive.desk"));
        }
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            splayer.openMenu(state.getMenuProvider(level, pos));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DeskBlockEntity(pos, state);
    }
}

