/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.be.DisplacedBlockEntity;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import dev.hyperlynx.reactive.util.BlockMoveChecker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DisplacedBlock
extends Block
implements EntityBlock {
    public DisplacedBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).isViewBlocking((state, getter, pos) -> false).noOcclusion().noLootTable().strength(1.0f).explosionResistance(-1.0f).sound(SoundType.CHAIN).pushReaction(PushReaction.IGNORE));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rng) {
        for (int i = 0; i < 4; ++i) {
            double x = (float)pos.getX() + rng.nextFloat();
            double y = (float)pos.getY() + rng.nextFloat();
            double z = (float)pos.getZ() + rng.nextFloat();
            level.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static boolean displace(BlockState state_to_be_displaced, BlockPos pos, Level level, int duration) {
        if (!level.isClientSide) {
            FlagTrigger.triggerForNearbyPlayers((ServerLevel)level, (FlagTrigger)((Object)ReactiveCriterionTriggers.SEE_DISPLACEMENT.get()), pos, 16);
        }
        return DisplacedBlock.displaceWithChain(state_to_be_displaced, pos, level, duration, 0, null);
    }

    public static boolean displaceWithChain(BlockState state_to_be_displaced, BlockPos pos, Level level, int duration, int depth, BlockPos chain) {
        if (level.getBlockEntity(pos) != null || !BlockMoveChecker.canDisplaceBlock(level, pos, state_to_be_displaced) || state_to_be_displaced.isAir()) {
            return false;
        }
        level.setBlock(pos, ((DisplacedBlock)((Object)ReactiveBlocks.DISPLACED_BLOCK.get())).defaultBlockState(), 2);
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof DisplacedBlockEntity)) {
            System.err.println("Displaced Block Entity didn't attach...? Report this to hyperlynx!");
            return false;
        }
        DisplacedBlockEntity displaced = (DisplacedBlockEntity)be;
        displaced.setSelfState(state_to_be_displaced);
        displaced.chain_target = chain;
        displaced.depth = depth;
        level.scheduleTick(pos, (Block)ReactiveBlocks.DISPLACED_BLOCK.get(), duration);
        return true;
    }

    private boolean shouldNotReappear(ServerLevel level, BlockPos pos, DisplacedBlockEntity self_entity) {
        if (self_entity.getSelfState() == null) {
            return true;
        }
        boolean ret = level.getBlockState(pos.below()).is((Block)ReactiveBlocks.VOLT_CELL.get());
        if (self_entity.chain_target != null) {
            ret = ret || level.getBlockState(self_entity.chain_target).is((Block)ReactiveBlocks.DISPLACED_BLOCK.get());
        }
        return ret;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rng) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (!(blockentity instanceof DisplacedBlockEntity)) {
            ReactiveMod.LOGGER.error("Something went wrong restoring block from displaced block. Report this to hyperlynx! I hope it wasn't expensive...");
            level.setBlock(pos, Blocks.GRAVEL.defaultBlockState(), 2);
            return;
        }
        DisplacedBlockEntity displaced = (DisplacedBlockEntity)blockentity;
        if (this.shouldNotReappear(level, pos, displaced)) {
            if (displaced.first_tick) {
                level.scheduleTick(pos, (Block)ReactiveBlocks.DISPLACED_BLOCK.get(), 2 + displaced.depth);
                displaced.first_tick = false;
            } else {
                level.scheduleTick(pos, (Block)ReactiveBlocks.DISPLACED_BLOCK.get(), 20);
            }
            return;
        }
        level.setBlockAndUpdate(pos, displaced.getSelfState());
        level.updateNeighborsAt(pos, (Block)this);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        DisplacedBlock.reform(level, pos);
        level.playSound(null, pos, SoundEvents.CHAIN_BREAK, SoundSource.PLAYERS, 1.0f, 0.8f);
        return true;
    }

    private static void reform(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DisplacedBlockEntity) {
            DisplacedBlockEntity displaced = (DisplacedBlockEntity)blockEntity;
            if (displaced.getSelfState().getBlock() instanceof DisplacedBlock) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                level.playSound(null, pos, SoundEvents.CHAIN_BREAK, SoundSource.PLAYERS, 1.0f, 0.6f);
                return;
            }
            if (level.getBlockState(pos.below()).is((Block)ReactiveBlocks.VOLT_CELL.get())) {
                level.destroyBlock(pos.below(), true);
            }
            level.setBlockAndUpdate(pos, displaced.getSelfState());
        } else {
            ReactiveMod.LOGGER.error("Didn't find a valid block entity associated with the displaced block at {}! Report this to hyperlynx!", (Object)pos);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean moving) {
        if (new_state.is((Block)ReactiveBlocks.DISPLACED_BLOCK.get())) {
            return;
        }
        DisplacedBlock.reform(level, pos);
        super.onRemove(state, level, pos, new_state, moving);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (!(entity instanceof DisplacedBlockEntity)) {
            return ItemStack.EMPTY;
        }
        DisplacedBlockEntity displaced_entity = (DisplacedBlockEntity)entity;
        if (displaced_entity.getSelfState().getBlock() instanceof DisplacedBlock) {
            return ItemStack.EMPTY;
        }
        return displaced_entity.getSelfState().getBlock().getCloneItemStack(state, target, level, pos, player);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DisplacedBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState p_48758_) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }
}

