/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.blocks.SymbolBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.PowerBottleItem;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveMobEffects;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class DivineSymbolBlock
extends SymbolBlock {
    public DivineSymbolBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource source) {
        double d0 = source.nextDouble() * 8.0 - 4.0;
        double d1 = source.nextDouble() * 8.0 - 4.0;
        double d2 = source.nextDouble() * 8.0 - 4.0;
        level.addParticle((ParticleOptions)ReactiveParticles.STARDUST, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, 0.0, 0.0, 0.0);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!(player.getItemInHand(hand).getItem() instanceof PowerBottleItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean accepted = false;
        BlockPos player_start_pos = player.blockPosition().above();
        if (((Power)Powers.VITAL_POWER.get()).matchesBottle(stack)) {
            if (player.getHealth() < 20.0f) {
                player.heal(20.0f);
                player.displayClientMessage((Component)Component.translatable((String)"message.reactive.donate_vital"), true);
                accepted = true;
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.reactive.reject_vital"), true);
            }
        } else if (((Power)Powers.LIGHT_POWER.get()).matchesBottle(stack)) {
            if (player.getActiveEffects().stream().anyMatch(mei -> mei.getEffect().equals((Object)MobEffects.INVISIBILITY))) {
                player.removeEffect(MobEffects.INVISIBILITY);
            } else {
                player.addEffect(new MobEffectInstance(MobEffects.GLOWING, 2400, 0, true, false));
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.reactive.donate_light"), true);
            accepted = true;
        } else if (((Power)Powers.WARP_POWER.get()).matchesBottle(stack)) {
            player.addEffect(new MobEffectInstance(ReactiveMobEffects.HIGH_STEP, 12000, 0, true, false));
            player.displayClientMessage((Component)Component.translatable((String)"message.reactive.donate_warp"), true);
            accepted = true;
        } else if (((Power)Powers.MIND_POWER.get()).matchesBottle(stack)) {
            player.addEffect(new MobEffectInstance(ReactiveMobEffects.FAR_REACH, 2800, 0, true, false));
            player.displayClientMessage((Component)Component.translatable((String)"message.reactive.donate_mind"), true);
            accepted = true;
        } else if (((Power)Powers.BLAZE_POWER.get()).matchesBottle(stack)) {
            if (player.getTicksFrozen() > 0) {
                player.setTicksFrozen(0);
            } else {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 100, 0, true, false));
                player.addEffect(new MobEffectInstance(ReactiveMobEffects.FIRE_SHIELD, 1900, 0, true, false));
                player.setRemainingFireTicks(100);
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.reactive.donate_blaze"), true);
            accepted = true;
        } else if (((Power)Powers.SOUL_POWER.get()).matchesBottle(stack)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.reactive.donate_reject_soul"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.reactive.donate_reject_generic"), true);
        }
        if (!player.isCreative() && accepted) {
            player.getItemInHand(hand).shrink(1);
            player.addItem(new ItemStack((ItemLike)ReactiveItems.QUARTZ_BOTTLE.get()));
        }
        if (accepted) {
            ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ReactiveParticles.STARDUST, pos, player_start_pos, 4, 5, 0.4);
            player.getCooldowns().addCooldown(stack.getItem(), 100);
        }
        return ItemInteractionResult.SUCCESS;
    }
}

