/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionEffects;
import dev.hyperlynx.reactive.be.GatewayBlockEntity;
import dev.hyperlynx.reactive.blocks.GatewayBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.QuartzBottleItem;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class GatewayPlinthBlock
extends Block {
    final ExplosionDamageCalculator COLLAPSE_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(false, false, Optional.of(Float.valueOf(1.8f)), Optional.empty());
    private final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0)});
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public GatewayPlinthBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
        super.createBlockStateDefinition(builder);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.SHAPE;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (level.getBlockState(pos.above()).is(Blocks.END_GATEWAY)) {
                GatewayPlinthBlock.convertEndGateway(slevel, pos.above());
                level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && !level.getBlockState(pos.above()).is((Block)ReactiveBlocks.GATEWAY_BLOCK.get())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
        super.neighborChanged(state, level, pos, pNeighborBlock, pNeighborPos, pMovedByPiston);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (level.getBlockState(pos.above()).is(Blocks.END_GATEWAY)) {
                GatewayPlinthBlock.convertEndGateway(slevel, pos.above());
            }
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (level.getBlockState(pos.above()).is((Block)ReactiveBlocks.GATEWAY_BLOCK.get())) {
            return ItemInteractionResult.CONSUME;
        }
        if (((Power)Powers.WARP_POWER.get()).matchesBottle(stack)) {
            if (WarpBottleItem.isRiftBottle(stack)) {
                GlobalPos warp_target = WarpBottleItem.getTeleportPosition(stack);
                if (warp_target == null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.reactive.activate_plinth_failed"), true);
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                GatewayPlinthBlock.setGateway(level, pos.above(), warp_target, state);
                level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
                level.playSound(null, pos, SoundEvents.EVOKER_CAST_SPELL, SoundSource.BLOCKS, 0.9f, 0.75f);
                level.playSound(null, pos, SoundEvents.BELL_RESONATE, SoundSource.BLOCKS, 0.3f, 1.0f);
                player.setItemInHand(hand, ((QuartzBottleItem)((Object)ReactiveItems.QUARTZ_BOTTLE.get())).getDefaultInstance());
                return ItemInteractionResult.SUCCESS;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                ResourceLocation warp_research = ReactiveMod.location("be_teleported");
                if (splayer.getAdvancements().getOrStartProgress(Advancement.Builder.advancement().build(warp_research)).isDone()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.reactive.reject_warp_knowledgeable"), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"message.reactive.reject_warp_naive"), true);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static void setGateway(Level level, BlockPos source, GlobalPos destination, BlockState self_state) {
        level.setBlock(source.below(), (BlockState)self_state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        level.setBlock(source, ((GatewayBlock)((Object)ReactiveBlocks.GATEWAY_BLOCK.get())).defaultBlockState(), 2);
        BlockEntity be = level.getBlockEntity(source);
        if (!(be instanceof GatewayBlockEntity)) {
            return;
        }
        GatewayBlockEntity gateway = (GatewayBlockEntity)be;
        gateway.target = destination;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean moved_by_piston) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && level.getBlockState(pos.above()).is((Block)ReactiveBlocks.GATEWAY_BLOCK.get())) {
            level.removeBlock(pos.above(), false);
            Vec3 rift_pos = Vec3.atCenterOf((Vec3i)pos.above());
            for (BlockPos point : ReactionEffects.getCreationPoints(pos)) {
                ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ReactiveParticles.STARDUST, pos.above(), point, 10, 7, 0.8);
            }
            level.explode(null, null, this.COLLAPSE_DAMAGE_CALCULATOR, rift_pos.x(), rift_pos.y(), rift_pos.z(), 3.0f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ReactiveParticles.STARDUST, (ParticleOptions)ParticleTypes.REVERSE_PORTAL, Holder.direct((Object)SoundEvents.BEACON_DEACTIVATE));
        }
        super.onRemove(state, level, pos, new_state, moved_by_piston);
    }

    private static void convertEndGateway(ServerLevel level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof TheEndGatewayBlockEntity)) {
            ReactiveMod.LOGGER.error("Tried to convert an inconvertible block at {}.", (Object)pos);
            return;
        }
        TheEndGatewayBlockEntity end_gateway = (TheEndGatewayBlockEntity)be;
        Vec3 target_vector = end_gateway.getPortalPosition(level, pos);
        if (target_vector == null) {
            ReactiveMod.LOGGER.error("No valid destination for the end gateway at {}.", (Object)pos);
            return;
        }
        level.setBlock(pos, ((GatewayBlock)((Object)ReactiveBlocks.GATEWAY_BLOCK.get())).defaultBlockState(), 2);
        BlockEntity be2 = level.getBlockEntity(pos);
        if (!(be2 instanceof GatewayBlockEntity)) {
            ReactiveMod.LOGGER.error("Something went wrong while converting the gateway at {}.", (Object)pos);
            return;
        }
        GatewayBlockEntity gateway = (GatewayBlockEntity)be2;
        gateway.target = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)BlockPos.containing((Position)target_vector));
    }
}

