/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.BaseStaffBlock;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class IncompleteStaffBlock
extends BaseStaffBlock {
    public static final IntegerProperty PROGRESS = IntegerProperty.create((String)"progress", (int)0, (int)3);
    private static final double RING_HEIGHT_1 = 0.8;
    private static final double RING_HEIGHT_2 = 1.1;
    private static final double RING_HEIGHT_3 = 1.4;

    public IncompleteStaffBlock(BlockBehaviour.Properties props) {
        super(props.lightLevel(bs -> (Integer)bs.getValue((Property)PROGRESS) > 0 ? 0 : 8));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public static void staffCraftStep(CrucibleBlockEntity c, BlockPos staff_pos) {
        for (Power p : c.getPowerMap().keySet()) {
            if (c.getPowerLevel(p) <= 800) continue;
            IncompleteStaffBlock.tryMakeProgress(Objects.requireNonNull(c.getLevel()), c.getLevel().getBlockState(staff_pos), staff_pos, p, c);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PROGRESS});
    }

    public static void tryMakeProgress(Level level, BlockState state, BlockPos pos, Power exposed_power, CrucibleBlockEntity crucible) {
        if (level.isClientSide) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            ParticleScribe.drawParticleReactionSurface(level, (ParticleOptions)new EnergyParticle.Options(exposed_power.getColor(), pos.above().getCenter().add(0.0, -0.15, 0.0)), crucible);
        }
        int order = WorldSpecificValues.EFFECT_ORDER.get();
        Power[] order1 = new Power[]{(Power)Powers.X_POWER.get(), (Power)Powers.Y_POWER.get(), (Power)Powers.Z_POWER.get()};
        Power[] order2 = new Power[]{(Power)Powers.Y_POWER.get(), (Power)Powers.Z_POWER.get(), (Power)Powers.X_POWER.get()};
        Power[] order3 = new Power[]{(Power)Powers.Z_POWER.get(), (Power)Powers.X_POWER.get(), (Power)Powers.Y_POWER.get()};
        if ((Integer)state.getValue((Property)PROGRESS) == 3) {
            Block staff_to_become = Blocks.AIR;
            if (exposed_power == Powers.LIGHT_POWER.get()) {
                staff_to_become = (Block)ReactiveBlocks.STAFF_OF_LIGHT.get();
            } else if (exposed_power == Powers.WARP_POWER.get()) {
                staff_to_become = (Block)ReactiveBlocks.STAFF_OF_WARP.get();
            } else if (exposed_power == Powers.BLAZE_POWER.get()) {
                staff_to_become = (Block)ReactiveBlocks.STAFF_OF_BLAZE.get();
            } else if (exposed_power == Powers.MIND_POWER.get()) {
                staff_to_become = (Block)ReactiveBlocks.STAFF_OF_MIND.get();
            } else if (exposed_power == Powers.VITAL_POWER.get()) {
                staff_to_become = (Block)ReactiveBlocks.STAFF_OF_LIFE.get();
            } else if (exposed_power == Powers.SOUL_POWER.get()) {
                staff_to_become = (Block)ReactiveBlocks.STAFF_OF_SOUL.get();
            }
            if (staff_to_become == Blocks.AIR) {
                return;
            }
            level.setBlock(pos, staff_to_become.defaultBlockState(), 2);
            level.playSound(null, pos, SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
        if (order == 1 && order1[(Integer)state.getValue((Property)PROGRESS)].equals(exposed_power) || order == 2 && order2[(Integer)state.getValue((Property)PROGRESS)].equals(exposed_power) || order == 3 && order3[(Integer)state.getValue((Property)PROGRESS)].equals(exposed_power)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PROGRESS, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PROGRESS) + 1)), 2);
            level.playSound(null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.1f);
        } else if (exposed_power.equals(Powers.X_POWER.get()) || exposed_power.equals(Powers.Y_POWER.get()) || exposed_power.equals(Powers.Z_POWER.get())) {
            IncompleteStaffBlock.failCrafting(level, pos);
        }
    }

    private static void failCrafting(Level l, BlockPos pos) {
        l.removeBlock(pos, true);
        ItemEntity dropped_staff = new ItemEntity(l, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, ((BlockItem)ReactiveItems.INCOMPLETE_STAFF.get()).getDefaultInstance());
        l.addFreshEntity((Entity)dropped_staff);
        l.playSound(null, pos, SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 1.0f, 1.1f);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rng) {
        if ((Integer)state.getValue((Property)PROGRESS) > 0 && (double)rng.nextFloat() < 0.05 + (double)((Integer)state.getValue((Property)PROGRESS)).intValue() * 0.1) {
            ParticleScribe.drawParticleRing(level, (ParticleOptions)ReactiveParticles.RUNE, pos, 0.8, (double)((Integer)state.getValue((Property)PROGRESS)).intValue() * 0.2 + 0.2, (Integer)state.getValue((Property)PROGRESS));
            level.playSound(null, pos, SoundEvents.BEACON_AMBIENT, SoundSource.BLOCKS, 0.3f, 1.1f);
        }
        if ((Integer)state.getValue((Property)PROGRESS) > 1 && (double)rng.nextFloat() < 0.05 + (double)((Integer)state.getValue((Property)PROGRESS)).intValue() * 0.1) {
            ParticleScribe.drawParticleRing(level, (ParticleOptions)ReactiveParticles.RUNE, pos, 1.1, (double)((Integer)state.getValue((Property)PROGRESS)).intValue() * 0.2 + 0.2, (Integer)state.getValue((Property)PROGRESS));
        }
        if ((Integer)state.getValue((Property)PROGRESS) > 2 && (double)rng.nextFloat() < 0.05 + (double)((Integer)state.getValue((Property)PROGRESS)).intValue() * 0.1) {
            ParticleScribe.drawParticleRing(level, (ParticleOptions)ReactiveParticles.RUNE, pos, 1.4, (double)((Integer)state.getValue((Property)PROGRESS)).intValue() * 0.2 + 0.2, (Integer)state.getValue((Property)PROGRESS));
        }
    }
}

